package cs2110;

/**
 * An implementation of the Queue ADT using a linked chain, developed via a composition relationship
 * with SinglyLinkedList.
 */
public class LinkedQueue<T> implements Queue<T> {

    /**
     * Stores the elements of this queue.
     */
    private final SinglyLinkedList<T> list;

    public LinkedQueue() {
        list = new SinglyLinkedList<>(); // establish the composition relationship
    }

    @Override
    public void enqueue(T elem) {
        list.add(elem);
    }

    @Override
    public T dequeue() {
        assert !isEmpty();
        return list.remove(0);
    }

    @Override
    public T peek() {
        assert !isEmpty();
        return list.get(0);
    }

    @Override
    public boolean isEmpty() {
        return list.size() == 0;
    }
}
