package cs2110;

/**
 * An implementation of the Stack ADT using a dynamic array, developed via a composition
 * relationship with DynamicArrayList.
 */
public class DynamicArrayStack<T> implements Stack<T> {

    /**
     * Stores the elements of this stack.
     */
    private final DynamicArrayList<T> list;

    public DynamicArrayStack() {
        list = new DynamicArrayList<>(); // establish the composition relationship
    }

    @Override
    public void push(T elem) {
        list.add(elem);
    }

    @Override
    public T pop() {
        assert !isEmpty();
        return list.remove(list.size() - 1);
    }

    @Override
    public T peek() {
        assert !isEmpty();
        return list.get(list.size() - 1);
    }

    @Override
    public boolean isEmpty() {
        return list.size() == 0;
    }
}
