package cs2110;

import cs2110.BipartiteGraph.Vertex;
import java.util.HashSet;
import java.util.LinkedList;

/**
 * Class which is utilized for finding the maximum matching on a graph with
 * fields 'graph' and 'matching'
 */
public class MaxBipartiteMatching {

    /**
     * Models an edge oriented from v1 to v2.
     */
     record Edge(Vertex v1, Vertex v2) {

        /**
         * Returns the edge oriented from v2 to v1
         */
        public Edge reverse() {
            return new Edge(v2, v1);
        }

        @Override
        public String toString() {
            return "(" + v1.label() + "," + v2.label() + ")";
        }
    }

    /**
     * A list of `Edge`s that form a contiguous path in a graph. The `v2` of one
     * `Edge` must be equal to the `v1` of the next `Edge`.
     */
    private static class Path extends LinkedList<Edge> {

    }

    /**
     * A set of bipartite graph `Edge`s oriented from their left vertex to their
     * right vertex.
     */
    public static class Matching extends HashSet<Edge> {

    }

    /**
     * Returns a maximum cardinality matching in the given bipartite `graph`.
     */
    public static Matching maxMatching(BipartiteGraph graph) {
        // TODO 3: implement this method according to its specifications.
        //  Within the method, use a local variable to keep track of the current matching. Write a
        //  loop iterating over all of the left vertices. If there is an augmenting path starting
        //  from that vertex, use it to update the current matching.
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the given `matching` using the given `augmentingPath`.
     */
    private static void augment(Matching matching, Path augmentingPath) {
        // TODO 1: implement this method according to its specifications.
        throw new UnsupportedOperationException();
    }

    /**
     * Returns an augmenting path in the given `graph` with the given source
     * vertex `v` and current `matching`, or returns `null` if no such
     * augmenting path exists.
     */
    private static Path findAugmentingPath(BipartiteGraph graph, Vertex v, Matching matching) {
        return dfsRecursive(v, matching, new HashSet<>());
    }

    /**
     * Returns a path from the left vertex `current` to a right vertex that is not present in the
     * given `matching`, traversing visiting only un`discovered` vertices (besides `current`).
     * Returns `null` if no such path exists.
     */
    private static Path dfsRecursive(Vertex current, Matching matching, HashSet<Vertex> discovered) {
        // TODO 2: implement this method based on the specs (there's also a scaffolding you can make use of).
        throw new UnsupportedOperationException();

//        // What are we exploring from `current`?
//        for (_______) {
//            // already visited
//            if (_________) {
//                continue;
//            }
//            Path path;
//            Vertex nextLeftVertex = ______ // utilize a given helper method to find this
//
//            // What do we do when we locate an unmatched right vertex? How do we see if it's unmatched?
//            if (nextLeftVertex _________) {
//                // What does finding an unmatched right vertex mean about our path?
//            }
//
//            // What do we do when we locate a matched right vertex?
//            discovered.add(_______); // we discover our vertex
//            path = dfsRecursive(nextLeftVertex, matching, discovered);
//
//            // We found a path from `nextLeftVertex`
//            if (________) {
//                path.addFirst(new Edge(______, nextLeftVertex));
//                path.addFirst(new Edge(current, ______));
//                return path;
//            }
//        }
//        return null;
    }

    /**
     * If `v` is the right vertex in some `Edge` in the given `matching`, then
     * the left vertex of this `Edge` is returned. Otherwise, `null` is
     * returned.
     */
    private static Vertex matchOfRightVertex(Vertex v, Matching matching) {
        for (Edge e : matching) {
            if (e.v2 == v) {
                return e.v1;
            }
        }
        return null;
    }
}
