package cs2110;

import static cs2110.MaxBipartiteMatching.maxMatching;
import static org.junit.jupiter.api.Assertions.*;

import cs2110.BipartiteGraph.Vertex;
import cs2110.MaxBipartiteMatching.Edge;
import cs2110.MaxBipartiteMatching.Matching;
import java.util.HashSet;
import org.junit.jupiter.api.Test;

public class MaxBipartiteMatchingTest {

    void assertMatchingOfSize(Matching matching, BipartiteGraph graph, int expectedSize) {
        assertEquals(expectedSize, matching.size());

        HashSet<Vertex> vertices = new HashSet<>();

        for (Edge e: matching) {
            assertTrue(graph.hasEdge(e.v1().label, e.v2().label));
            assertTrue(vertices.add(e.v1()));
            assertTrue(vertices.add(e.v2()));
        }
    }

    @Test
    public void testGraph1() {
        BipartiteGraph graph = new BipartiteGraph();

        graph.addLeftVertex("Alpha");
        graph.addLeftVertex("Bravo");
        graph.addLeftVertex("Charlie");
        graph.addLeftVertex("Delta");
        graph.addLeftVertex("Echo");

        graph.addRightVertex("P1");
        graph.addRightVertex("P2");
        graph.addRightVertex("P3");
        graph.addRightVertex("P4");
        graph.addRightVertex("P5");

        graph.addEdge("Alpha", "P1");
        graph.addEdge("Alpha", "P2");
        graph.addEdge("Bravo", "P1");
        graph.addEdge("Bravo", "P3");
        graph.addEdge("Charlie", "P2");
        graph.addEdge("Charlie", "P4");
        graph.addEdge("Delta", "P3");
        graph.addEdge("Delta", "P4");
        graph.addEdge("Echo", "P4");
        graph.addEdge("Echo", "P5");

        assertMatchingOfSize(maxMatching(graph),graph,5);
    }

    @Test
    public void testGraph2() {
        BipartiteGraph graph = new BipartiteGraph();

        graph.addLeftVertex("A");
        graph.addRightVertex("1");
        graph.addLeftVertex("B");
        graph.addRightVertex("2");

        graph.addEdge("A", "1");
        graph.addEdge("1", "B");
        graph.addEdge("B", "2");

        assertMatchingOfSize(maxMatching(graph),graph,2);
    }

    @Test
    public void testGraph3() {
        BipartiteGraph graph = new BipartiteGraph();

        graph.addLeftVertex("A");
        graph.addLeftVertex("B");
        graph.addLeftVertex("C");
        graph.addLeftVertex("D");
        graph.addLeftVertex("E");

        graph.addRightVertex("1");
        graph.addRightVertex("2");
        graph.addRightVertex("3");
        graph.addRightVertex("4");
        graph.addRightVertex("5");

        graph.addEdge("A", "1");
        graph.addEdge("B", "1");
        graph.addEdge("B", "2");
        graph.addEdge("C", "2");
        graph.addEdge("C", "3");
        graph.addEdge("D", "3");
        graph.addEdge("D", "4");
        graph.addEdge("E", "4");
        graph.addEdge("E", "5");

        assertMatchingOfSize(maxMatching(graph),graph,5);
    }

    @Test
    public void testGraph4() {
        BipartiteGraph graph = new BipartiteGraph();

        graph.addLeftVertex("A");
        graph.addLeftVertex("B");
        graph.addLeftVertex("C");
        graph.addLeftVertex("D");

        graph.addRightVertex("1");
        graph.addRightVertex("2");
        graph.addRightVertex("3");

        graph.addEdge("A", "1");
        graph.addEdge("B", "1");
        graph.addEdge("C", "2");
        graph.addEdge("D", "3");

        assertMatchingOfSize(maxMatching(graph),graph,3);
    }

    @Test
    public void testGraph5() {
        BipartiteGraph graph = new BipartiteGraph();

        // Left vertices
        graph.addLeftVertex("A");
        graph.addLeftVertex("B");
        graph.addLeftVertex("C");
        graph.addLeftVertex("D");
        graph.addLeftVertex("E");
        graph.addLeftVertex("F");

        // Right vertices
        graph.addRightVertex("1");
        graph.addRightVertex("2");
        graph.addRightVertex("3");
        graph.addRightVertex("4");
        graph.addRightVertex("5");
        graph.addRightVertex("6");

        // Edges forming overlapping chains
        graph.addEdge("A", "1");
        graph.addEdge("A", "2");

        graph.addEdge("B", "2");
        graph.addEdge("B", "3");

        graph.addEdge("C", "3");
        graph.addEdge("C", "4");

        graph.addEdge("D", "4");
        graph.addEdge("D", "5");

        graph.addEdge("E", "5");
        graph.addEdge("E", "6");

        graph.addEdge("F", "6");

        assertMatchingOfSize(maxMatching(graph),graph,6);
    }

}
