package cs2110;

import static org.junit.jupiter.api.Assertions.*;

import java.nio.file.Files;
import java.nio.file.Paths;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class HuffmanCodingTest {

    @DisplayName("WHEN a file is encode()d and then decode()d, THEN its original contents are "
            + "recovered.")
    @Test
    public void testHuffmanReversable() throws Exception {
        HuffmanCoding.encode("verne.txt", "verne_encoded.txt");
        HuffmanCoding.decode("verne_encoded.txt", "verne_decoded.txt");
        String expected = Files.readString(Paths.get("verne.txt"));
        String[] expectedLines = expected.split("\n");
        String actual = Files.readString(Paths.get("verne_decoded.txt"));
        String[] actualLines = actual.split("\n");
        assertArrayEquals(expectedLines,actualLines);
    }

}
