package cs2110;

import java.util.Iterator;

/**
 * An immutable implementation of a binary tree.
 */
public class ImmutableBinaryTree<T> extends BinaryTree<T> {

    /**
     * The left subtree of this tree.
     */
    private final ImmutableBinaryTree<T> left;

    /**
     * The right subtree of this tree.
     */
    private final ImmutableBinaryTree<T> right;

    /*
     * Note: Here, we provide two *overloaded* constructors (i.e., constructors with different
     * parameter signatures) to make it easier to construct different binary (sub)trees.
     */

    /**
     * Constructs a binary tree with the given `root` value and `left` and `right` subtrees.
     */
    public ImmutableBinaryTree(T root, ImmutableBinaryTree<T> left, ImmutableBinaryTree<T> right) {
        this.root = root;
        this.left = left;
        this.right = right;
    }

    /**
     * Constructs a binary tree with the given `root` value and two empty subtrees.
     */
    public ImmutableBinaryTree(T root) {
        this.root = root;
        this.left = null;
        this.right = null;
    }

    @Override
    protected ImmutableBinaryTree<T> left() {
        return left;
    }

    @Override
    protected ImmutableBinaryTree<T> right() {
        return right;
    }

    public static void main(String[] args) {
        BinaryTree<Integer> tree = new ImmutableBinaryTree<>(3,
                new ImmutableBinaryTree<>(1,
                        new ImmutableBinaryTree<>(4,
                                new ImmutableBinaryTree<>(5),
                                new ImmutableBinaryTree<>(7)),
                        new ImmutableBinaryTree<>(8)
                ),
                new ImmutableBinaryTree<>(2,
                        new ImmutableBinaryTree<>(5,
                                new ImmutableBinaryTree<>(6),
                                null),
                        null
                )
        );
        System.out.println(tree);

        System.out.print("In-order: ");
        for (Integer e : tree) {
            System.out.print(e + " ");
        }

        System.out.print("\nPre-order: ");
        Iterator<Integer> it = tree.preorderIterator();
        while (it.hasNext()) {
            System.out.print(it.next() + " ");
        }

        System.out.print("\nPost-order: ");
        it = tree.postorderIterator();
        while (it.hasNext()) {
            System.out.print(it.next() + " ");
        }
    }
}
