package cs2110;

public class PalindromeChecker {

    /**
     * Returns whether `s` is a palindrome (ignoring case-sensitivity), meaning it reads the same
     * forwards and backwards. (Bonus challenge: ignore all non-alphanumeric characters)
     */
    static boolean isPalindrome(String s) {
        int len = s.length();
        if (len <= 1) {
            return true;
        }
        s = s.toLowerCase();
        return s.charAt(0) == s.charAt(len - 1) && isPalindrome(s.substring(1, len - 1));
    }

    /**
     * Returns whether `s.substring(start, end)` is a palindrome. This method should be recursive and
     * should not construct any new `String` objects during its execution. Requires that `s`
     * consists of only characters from 'a'-'z', and `0 <= start <= end < s.length`.
     */
    static boolean rangeIsPalindrome(String s, int start, int end) {
        if (end - start <= 1) {
            return true;
        }
        return s.charAt(start) == s.charAt(end - 1) && rangeIsPalindrome(s, start + 1, end - 1);
    }

}