package traversals;

import java.util.*;
import java.util.function.Consumer;

public class Traversals {
    /**
     * Traverse all vertices reachable from `start` in a breadth-first-search order, performing
     * `preAction.accept()` on each one as it is visited.
     */
    public static void bfsWalk(Vertex start, Consumer<String> preAction) {
        // Set of all vertex labels that have been discovered.
        Set<String> discovered = new HashSet<>();

        // Queue of discovered vertices that have not yet been visited (FIFO in discovery order).
        Queue<Vertex> frontier = new LinkedList<>();

        // Loop precondition: Discover `start`.
        discovered.add(start.label());
        frontier.add(start);

        // TODO: implement. Call `preAction.accept()` when you visit a node.
        // Pseudocode:
        // while frontier is not empty:
        //      remove next vertex from frontier
        //      for each of its neighbors:
        //          if neighbor has not been discovered:
        //              Mark neighbor as discovered and add to frontier
        //      (the vertex is now settled)
    }

    /**
     * Compute the minimum path length from `start` to all vertices reachable from it.  The returned
     * map associates each reachable vertex's label with its distance from `start`, and iterating
     * over the map will yield vertex labels in ascending order of distance (that is, in a
     * breadth-first search order).  Here, path "length" and "distance" refer to the number of edges
     * (edge weights are ignored).
     */
    public static Map<String, Integer> bfsDistances(Vertex start) {
        // Map of vertex labels to distance from `start`.
        // Use LinkedHashMap to preserve discovery order in return value.
        Map<String, Integer> dists = new LinkedHashMap<>();

        // Queue of discovered vertices that have not yet been visited (FIFO in discovery order).
        Queue<Vertex> frontier = new LinkedList<>();

        // Discover `start`.
        dists.put(start.label(), 0);
        frontier.add(start);

        // TODO: adapt the implementation of bfsWalk() to now return a map of distances.
        throw new UnsupportedOperationException();
    }

}