import java.io.IOException;
import java.util.*;

public class Main3 {

    /**
     * Given a set of target courses in `args`, print a topological ordering of those courses and
     * their prerequisites.
     */
    public static void main(String[] args) throws IOException {
        // Load course dependency database
        Graph courseDeps = OopGraph.readGraph("courses.txt");

        // Store targets from program arguments in a set (for fast lookup)
        Set<String> targets = new HashSet<>(Arrays.asList(args));
        // FIXME: warn if any targets are not in the dependency graph

        // Perform topological sort of prerequisite graph, keeping only vertices on path to targets
        List<Vertex> seq = topoSort(courseDeps, targets);

        // Print filtered topological ordering
        for (Vertex n : seq) {
            System.out.println(n.label());
        }
    }

    /**
     * Perform a topological sort of the vertices in `graph` (need not be connected) and return the
     * subset of vertices on paths that terminate with labels in `targets`. Throws
     * IllegalArgumentException if graph is cyclic.
     */
    public static List<Vertex> topoSort(Graph graph, Set<String> targets) {
        // Allocate list for assembling result (TODO: construct)
        List<Vertex> ans = null;

        // Create data structure(s) for storing auxiliary vertex data

        // For each vertex in the graph:
        //     If v is undiscovered:
        //         Visit v (note: this checks for cycles for us)

        return ans;
    }

    /**
     * Perform a depth-first search starting at `start`.  If a vertex with a label in `targets` is
     * reachable from `start`, prepend `start` to `order` and return true; otherwise, return false.
     * Throws IllegalArgumentException if subgraph reachable from `start` is cyclic.
     */
    private static boolean dfsVisit(Vertex start, Set<String> targets, List<Vertex> order
            /* , additional parameters */) {
        // Initialize result accumulator
        boolean reachesTarget = targets.contains(start.label());

        // Mark start as discovered

        // For each successor v of start:
        //     If v is undiscovered:
        //         Visit v (hint: and update accumulator)
        //     Otherwise, if v is not settled:
        //         ERROR: graph is cyclic
        //     Otherwise, v is settled; was it on a path to a target?

        // Settling actions
        // Mark start as settled

        return reachesTarget;
    }
}
