package cs2110;

import static org.junit.jupiter.api.Assertions.*;

import java.util.Iterator;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class RingBufferBQIteratorTest {

    @DisplayName("hasNext() should return false when RingBufferBQ is empty")
    @Test
    public void testIteratorEmpty() {
        RingBufferBQ<Integer> rb = new RingBufferBQ<>(1);
        Iterator<Integer> rbIter = rb.iterator();
        assertFalse(rbIter.hasNext());
    }

    @DisplayName("hasNext() should return true, and next() should return the corresponding value "
            + "when called on a single-element RingBufferBQ")
    @Test
    public void testIteratorOneElement() {
        RingBufferBQ<Integer> rb = new RingBufferBQ<>(3);
        rb.put(1);
        Iterator<Integer> rbIter = rb.iterator();
        assertTrue(rbIter.hasNext());
        assertEquals(rbIter.next(), 1);
        assertFalse(rbIter.hasNext());
    }

    @DisplayName("hasNext() should return true, and next() should return the corresponding values "
            + "when called on a RingBufferBQ with multiple elements "
            + "with no elements previously removed.")
    @Test
    public void testIteratorMultipleElements() {
        RingBufferBQ<Integer> rb = new RingBufferBQ<>(10);
        for (int i = 0; i < 10; i++) {
            rb.put(i);
        }
        Iterator<Integer> rbIter = rb.iterator();
        int counter = 0;
        while (rbIter.hasNext()) {
            assertEquals(rbIter.next(), counter);
            counter++;
        }
    }

    @DisplayName("hasNext() should return true, and next() should return the corresponding values "
            + "when called on a RingBufferBQ with multiple elements "
            + "with at least one element previously removed.")
    @Test
    public void testIteratorMultipleElementsShiftHead() {
        RingBufferBQ<Integer> rb = new RingBufferBQ<>(10);
        rb.put(-1);
        assertEquals(-1, rb.get());
        for (int i = 0; i < 10; i++) {
            rb.put(i);
        }
        Iterator<Integer> rbIter = rb.iterator();
        int counter = 0;
        while (rbIter.hasNext()) {
            assertEquals(rbIter.next(), counter);
            counter++;
        }
    }

    @DisplayName("RingBufferBQ elements can be iterated over via an enhanced for loop")
    @Test
    public void testEnhancedForLoop() {
        // TODO 1C: Write a test that iterates over elements of RingBufferBQ via an enhanced for loop.
        // Use a RingBufferBQ with a different capacity than the above tests.
    }

}
