package cs2110;


/**
 * A Queue ADT (FIFO) with a limited capacity of stored elements. If the capacity is met,
 * no further elements can be added before elements are removed. Additionally, if the queue
 * is empty, no elements can be removed.
 * @param <E> - the type of elements held in the queue
 */
public interface BoundedQueue<E> extends Iterable<E> {

    /**
     * Inserts a value `x` to the queue if capacity is not met.
     */
    public void put(E x);

    /**
     * Remove and return the oldest value in the queue, if such a value exists.
     */
    public E get();

    /**
     * Returns true if no element can currently be added to the queue.
     */
    public boolean isFull();

    /**
     * Returns true if no element can be consumed from the queue.
     */
    public boolean isEmpty();
}
