package cs2110;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import java.util.NoSuchElementException;

import static org.junit.jupiter.api.Assertions.*;

public class RingBufferBQTest {

    @DisplayName("Attempting to get a value from an empty buffer should result in a NoSuchElementException")
    @Test
    public void testGetEmpty() {
        RingBufferBQ<Integer> rb = new RingBufferBQ<>(10);
        assertThrows(NoSuchElementException.class, () -> {rb.get();});
    }

    @DisplayName("After adding a single element into a buffer, get() should return the element")
    @Test
    public void testGetSingleElement() {
        RingBufferBQ<Integer> rb = new RingBufferBQ<>(10);
        rb.put(0);
        assertEquals(0, rb.get());
    }

    @DisplayName("After adding multiple elements into a buffer, get() should return them in order")
    @Test
    public void testGetMultipleElements() {
        RingBufferBQ<Integer> rb = new RingBufferBQ<>(10);
        for (int i = 0; i < 5; i++) {
            rb.put(i);
        }
        int counter = 0;
        while (!rb.isEmpty()) {
            assertEquals(counter, rb.get());
            counter++;
        }
        assertTrue(rb.isEmpty());
    }

    @DisplayName("Calling get() on a full buffer should make the buffer no longer full")
    @Test
    public void testGetFullBuffer() {
        RingBufferBQ<Integer> rb = new RingBufferBQ<>(5);
        while (!rb.isFull()) {
            rb.put(0);
        }
        rb.get();
        assertFalse(rb.isFull());
    }
}
