import java.io.*;
import java.util.*;

/**
 * Keep track of which distinct words appear on which lines of a file.
 */
public class Index {
    private List<Set<String>> lineWords;

    /**
     * Create an Index for the file named `filename`.  Words are separated by whitespace and are
     * case-sensitive.
     */
    public Index(String filename) throws IOException {
        lineWords = new ArrayList<Set<String>>();

        // Read each line
        try (Reader in = new FileReader(filename)) {
            Scanner lines = new Scanner(in);
            while (lines.hasNextLine()) {

                // Beginning-of-line actions
                Set<String> words = new HashSet<String>();
                String line = lines.nextLine();

                // Process each word on the line (separated by whitespace)
                Scanner tokens = new Scanner(line);
                while (tokens.hasNext()) {
                    String word = tokens.next();
                    // Process `word`
                    words.add(word);
                }

                // End-of-line actions
                lineWords.add(words);
            }
        }
    }

    /**
     * Creates a set of the distinct words on line number `lineNum` in the file that was indexed.
     * The first line of the file has line number 1.  Requires {@code lineNum >= 1}.  Throws
     * `IndexOutOfBoundsException` if `lineNum` exceeds the number of lines in the file.
     */
    public Set<String> wordsOnLine(int lineNum) {
        // TODO
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a list of the line numbers on which `word` occurs in the file that was indexed.  The
     * first line of the file has line number 1.  The returned line numbers are in ascending order.
     */
    public List<Integer> linesWithWord(String word) {
        // TODO
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws IOException {
        Index index = new Index("Austen.txt");

        // TODO: How many distinct words are on line 18?

        // TODO: Does line 13 contain the word "young"?

        // TODO: How many lines does "with" appear on?
    }
}
