import java.util.Iterator;

/** Node in a potentially circular linked list. */
public class CNode<T> implements Iterable<T> {
    /** The value at this location in the list. */
    T value;

    /** The node after this one in the list; may be null. */
    CNode<T> next;

    /** `next` may be null. */
    public CNode(T value, CNode<T> next) {
        this.value = value;
        this.next = next;
    }

    /** Returns an iterator over elements in the list, starting with this node's value.
     *  Precondition: list is linear, or this node is on circular portion. */
    @Override
    public Iterator<T> iterator() {
        return new CNodeIterator<T>(this);
    }

    /** Demo: Iterate over a circular linked list with 4 nodes. */
    public static void main(String[] args) {
        CNode<String> n4 = new CNode<>("E", null);
        CNode<String> n3 = new CNode<>("F", n4);
        CNode<String> n2 = new CNode<>("A", n3);
        CNode<String> n1 = new CNode<>("C", n2);
        n4.next = n1;  // Make circular

        // Enhanced for-loop uses CNode.iterator()
        for (String s : n1) {
            System.out.print(s + " ");
        }
        System.out.println();
    }
}
