import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Main3 {
    /**
     * Given a set of target courses in `args`, print a topological ordering of those courses and
     * their prerequisites.
     */
    public static void main(String[] args) throws IOException {
        // Load course dependency database
        Iterable<Vertex> courseDeps = Vertex.readGraph("courses.txt");

        // Store targets from program arguments in a set (for fast lookup)
        Set<String> targets = new HashSet<>(Arrays.asList(args));
        // FIXME: warn if any targets are not in the dependency graph

        // Perform topological sort of prerequisite graph, keeping only vertices on path to targets
        List<Vertex> seq = topoSort(courseDeps, targets);

        // Print filtered topological ordering
        for (Vertex n : seq) {
            System.out.println(n.label());
        }
    }

    /**
     * Perform a topological sort of the graph whose vertices are in `vertices` (need not be
     * connected) and return the subset of vertices on paths that terminate with labels in
     * `targets`.
     * Throws IllegalArgumentException if graph is cyclic.
     */
    public static List<Vertex> topoSort(Iterable<Vertex> vertices, Set<String> targets) {
        // Allocate list for assembling result (TODO: construct)
        List<Vertex> ans = null;

        // Create data structure(s) for storing auxiliary vertex data

        // For each vertex in the graph:
            // If v is undiscovered:
                // Visit v (note: this checks for cycles for us)

        return ans;
    }

    /**
     * Perform a depth-first search starting at `g`.  If a vertex with a label in `targets` is
     * reachable from `g`, prepend `g` to `order` and return true; otherwise, return false.
     * Throws IllegalArgumentException if subgraph reachable from `g` is cyclic.
     */
    private static boolean dfsVisit(Vertex g, Set<String> targets, List<Vertex> order
            /* , additional parameters */) {
        // Initialize result accumulator
        boolean reachesTarget = targets.contains(g.label());

        // Mark g as discovered

        // For each successor v of g:
            // If v is undiscovered:
                // Visit v (hint: and update accumulator)
            // Otherwise, if v is not settled:
                // ERROR: graph is cyclic
            // Otherwise, v is settled; was it on a path to a target?

        // Settling actions
        // Mark g as settled

        return reachesTarget;
    }
}
