package lecture16;

import java.security.SecureRandom;
import java.util.Date;
import java.util.Random;

public class SortingAlgorithms {
    public static void main(String[] args) {
        int n = 5;
        int[] a = randomArray(n);
        int sum = 0;
        for (int i = 0; i < n; i++) {
            sum += a[i];
        }
        insertionSort(a);
        // selectionSort(a);
        // mergeSort(a, 0, n, new int[n]);
        // quickSort(a, 0, n);
        for (int i = 0; i < n; i++) {
            sum -= a[i];
        }
        if (sum != 0) {
            System.out.println("Sort unsuccessful");
        }
        for (int i = 0; i < n-1; i++) {
            if (a[i] > a[i+1])
                System.out.println("Sort unsuccessful");
        }

        System.out.println("size,time (ms)");
        for (int size = 100; size <= 10000000; size *= 10) {
            a = randomArray(size);
            double t0 = new Date().getTime();
            insertionSort(a);
            // selectionSort(a);
            // mergeSort(a, 0, size, new int[size]);
            // quickSort(a, 0, size);
            double t1 = new Date().getTime();
            System.out.println(size + "," + (t1-t0));
        }

    }

    /** Effect: rearrange the elements of a into ascending order. */
    static void insertionSort(int[] a) {
        for (int i = 1; i < a.length; i++) {
            // loop invariant:
            //    1. 1 ≤ i ≤ a.length
            //    2. a[0..i) is sorted in ascending order
            //    3. a contains a permutation of the original sequence of elements in a
            int k = a[i];
            int j = i;
            for (; j > 0 && a[j-1] > k; j--) {
                a[j] = a[j-1];
            }
            a[j] = k;
        }
    }

    static void selectionSort(int[] a) {
        int n = a.length;
        for (int i = 0; i < n-1; i++) {
            // loop invariant:
            //    1. 0 ≤ i ≤ n-1
            //    2. a[0..i) contains the smallest i elements in a, in sorted order.
            //    3. a contains a permutation of the original sequence of elements in a

            // find smallest element k = a[p] in subarray a[i..n-1)
            int k = a[i], p = i;
            for (int j = i+1; j < n; j++) {
                if (a[j] < k) {
                    k = a[j];
                    p = j;
                }
            }
            // swap a[i] and a[p]
            a[p] = a[i];
            a[i] = k;
        }
    }

    /** Effect: sort the elements of a[l..r) (ascending order)
     *  Requires: 0 ≤ l < r ≤ a.length
     */
    static void mergeSort(int[] a, int l, int r, int[] tmp) {
        if (r == l + 1) return;
        int m = (l + r)/2;
        mergeSort(a, l, m, tmp);
        mergeSort(a, m, r, tmp);
        merge(a, l, m, r, tmp);
    }

    /** Effect: sort the elements of a[l..r) (ascending order)
     *  Requires: 0 ≤ l < m < r ≤ a.length, and a[l..m) and a[m..r) sorted.
     */
    private static void merge(int[] a, int l, int m, int r, int[] tmp) {
        int i = l, j = m, k = l;
        while (i < m && j < r) {
            if (a[i] < a[j]) {
                tmp[k] = a[i];
                i++;
            } else {
                tmp[k] = a[j];
                j++;
            }
            k++;
            //  or: tmp[k++] = (a[i] < a[j]) ? a[i++] : a[j++];
        }
        System.arraycopy(a, i, tmp, k, m-i);
        System.arraycopy(tmp, l, a, l, j-l);
    }

    /**
     * Effect: sort a[l..r).
     * Requires: 0 ≤ l < r ≤ a.length
     */
    static void quickSort(int[] a, int l, int r) {
        if (r == l + 1)
            return;
        // 1. partition & 2. split
        int k = partition(a, l, r);
        // 3. sort recursively
        quickSort(a, l, k);
        quickSort(a, k, r);
    }

    static Random rnd = new Random();

    /** Returns: k such that l < k < r.
     *  Effect: permute a so a[l..k) ≤ p and a[k..r) ≥ p for some value p.
     *  Requires: 0 ≤ l < r ≤ a.length
     */
    private static int partition(int[] a, int l, int r) {
        int p = a[l];
        int i = l-1, j = r;
        while (true) {
            assert l-1 <= i && i <= j && j <= r;
            do i++; while (a[i] < p);
            do j--; while (a[j] > p);
            if (i >= j) break;
            int t = a[i]; a[i] = a[j]; a[j] = t;
        }
        return j+1;
    }

    private static int[] randomArray(int n) {
        Random rnd = new SecureRandom(new byte[]{17});
        int[] result = new int[n];
        for (int i = 0; i < n; i++) {
            result[i] = rnd.nextInt(100);
        }
        return result;
    }
}