package lecture15;

import java.security.SecureRandom;
import java.util.Date;
import java.util.Random;

public class Main {
    public static void main(String[] args) {
        int n = 10000;
        int[] a = randomArray(n);
        int sum = 0;
        for (int i = 0; i < n; i++) {
            sum += a[i];
        }
        insertionSort(a);
        for (int i = 0; i < n; i++) {
            sum -= a[i];
        }
        if (sum != 0) {
            System.out.println("Sort unsuccessful");
        }
        for (int i = 0; i < n-1; i++) {
            if (a[i] > a[i+1])
                System.out.println("Sort unsuccessful");
        }

        System.out.println("size,time (ms)");
        for (int size = 100; size <= 1000000; size *= 10) {
            a = randomArray(size);
            double t0 = new Date().getTime();
            insertionSort(a);
            double t1 = new Date().getTime();
            System.out.println(size + "," + (t1-t0));
        }

    }

    /** Effect: rearrange the elements of a into ascending order. */
    static void insertionSort(int[] a) {
        for (int i = 1; i < a.length; i++) {
            // invariant: a[0..i) is sorted
            int k = a[i];
            int j = i;
            while (j > 0 && a[j-1] > k) {
                a[j] = a[j-1];
                j--;
            }
            a[j] = k;
        }
    }

    private static int[] randomArray(int n) {
        Random rnd = new SecureRandom(new byte[]{17});
        int[] result = new int[n];
        for (int i = 0; i < n; i++) {
            result[i] = rnd.nextInt();
        }
        return result;
    }

}
