package lecture15;

public class BinarySearches {

    /**
     * Returns i where a[i] == k requires: k is in a and a sorted in ascending order.
     */
    static int search(int[] a, int k) {
        int l = 0, r = a.length - 1;
        // Loop invariant:
        // 1. a is sorted
        // 2. 0 <= l <= r < a.length
        // 3. k in a[l..r]
        while (l < r) {
            int m = (l + r) / 2;
            if (k < a[m])
                r = m;
            else
                l = m + 1;
        }
        return l;
    }

    // Every loop can be written as a tail-recursive function

    /**
     * Returns i where a[i] == k requires: k is in a and a sorted in ascending order.
     */
    static int search2(int[] a, int k) {
        int l = 0, r = a.length - 1;
        return loop(a, k, l ,r);
    }

    /** Returns: i where k==a[i] and l <= i <= r
     *  Requires:
     *    1. a is sorted
     *    2. 0 ≤ l ≤ r < a.length
     *    3. k ∈ a[l..r]
     *   precondition is the loop invariant above
     *   to find a loop invariant, write loop as  recursive function
     *   & identify precondition.
     *
     */
    static int loop(int[] a, int k, int l, int r) {
        if (l >= r) return l; // base case
        int m = (l + r) / 2;
        if (k < a[m])
            return loop(a, k, l, m); // r = m;
        else
            return loop(a, k, m+1, r); // l = m + 1;
        // tail-recursive: recursive call is only used to directly compute
        // result.
        // Any tail-recursive function can be written as a loop and vice versa
    }
}

