package lecture13;

/** An immutable 2D point */
public final class Point { // final = "cannot be subclassed"
    final int x, y; // final = "cannot be assigned after constructor"
    public Point(int x, int y) {
        this.x = x; this.y = y;
    }
    @Override
    public boolean equals(Object o) {
        if (o instanceof Point p) {
            return (x == p.x && y == p.y); // immutable => state equality
        }
        return false;
    }
    static final int BIG_PRIME = 299671;
    @Override
    public int hashCode() {
        return x * BIG_PRIME + y;
    }

    // what about hashCode()?
}