package lecture12;

import jdk.incubator.vector.VectorOperators.Binary;

// Binary tree: each node can have left and right child (distinguished)
public class BinaryNode<T> {
    T data;
    BinaryNode<T> left, right; // may be null
    Comparator<T> comparator;

    BinaryNode(T x) {
        data = x;
        left = right = null;
    }

    /** return null if not found */
    BinaryNode<T> search(T e) {
        int c = comparator.compare(e, data);
        if (c == 0) { return this; }
        if (c < 0) {
            if (left == null) return null;
            return left.search(e); // recurse
        } else {
            if (right == null) return null;
            return right.search(e);
        }
    }

    /** Adds element e to the tree, returns true if it wasn't there*/
    boolean add(T e) {
        // do a search to find the right place
        int c = comparator.compare(e, data);
        if (c == 0) { return false; }
        if (c < 0) {
            if (left != null) return left.add(e);
            else left = new BinaryNode<T>(e);
        } else {
            if (right != null) return right.add(e);
            else right = new BinaryNode<T>(e);
        }
        return true;
    }



}
