package lecture11;

import java.security.SecureRandom;
import java.util.Date;
import java.util.Random;

public class Search {
    final static int[] SIZES = {10, 100, 10000, 1000000, 100000000, 1000000000};

    public static void main(String[] args) {
        int[] a = new int[1000];
        for (int i = 0; i < a.length; i++) a[i] = i;
        Random r = new SecureRandom();
        // Warm up JVM JIT for 2 seconds
        double t00 = new Date().getTime();
        while (new Date().getTime() - t00 < 2000) {
            linearSearch(a, r.nextInt(a.length));
            binarySearch(a, r.nextInt(a.length), 0, a.length - 1);
        }
        System.out.println("Starting to time algorithms");
        for (int sizeIndex = 0; sizeIndex < SIZES.length; sizeIndex++) {
            final int N = SIZES[sizeIndex];
            final int REPS = 1000000000 / N;
            a = new int[N];
            for (int i = 0; i < a.length; i++) a[i] = i;

            System.out.println("Size = " + N);
            double t0 = new Date().getTime();
            for (int rep = 0; rep < REPS; rep++) {
                linearSearch(a, r.nextInt(N));
            }
            double t1 = new Date().getTime();
            System.out.println("Linear search time: " + 1000 * (t1 - t0) / REPS + " μs");
            int bsReps = 0;
            while (new Date().getTime() - t1 < 1000) {
                bsReps += REPS;
                for (int rep = 0; rep < REPS; rep++) {
                    binarySearch(a, r.nextInt(N), 0, N - 1);
                }
            }
            double t2 = new Date().getTime();
            System.out.println("Binary search time: " + 1000 * (t2 - t1) / bsReps + " μs");
        }
    }

    /** Returns: i such that a[i] == k
     *  Requires: such an i exists */
    static int linearSearch(int[] a, int k) {
        for (int i = 0; i < a.length; i++) {
            if (a[i] == k) return i;
        }
        return -1;
    }

    /** Returns: i such that a[i] == k and i ∈ [l, r]
     *  Requires: such an i exists, a is sorted in ascending order,
     *  and 0 ≤ l ≤ r < a.length */
    static int binarySearch(int[] a, int k, int l, int r) {
        if (l == r) return l; // base case
        int m = (l + r)/2;
        if (k <= a[m]) {
            return binarySearch(a, k, l, m); // calling on half the elements
        } else {
            return binarySearch(a, k, m+1, r);// calling on half the elements
        }
    }
    // if n = r-l+1 is a power of two: 2^j, 2^(j-1), 2^(j-2),..., 1
    // total recursive calls: j
    // total time: body is O(1) + j recursive calls * O(1)
    // total time: O(log_2 n) = O(log n) = O(lg n)
}
