package lecture08;

public class Node {
    Object data;
    Node next;

    /** Creates: a list with x at the head, sharing nodes with the
     * list starting from n.
     */
    Node(Node n, Object x) {
       data = x;
       next = n;
    }

    public static void main(String[] args) {
        Node n = new Node();
        n.data = 42;
        System.out.println("result = " + n);
    }

    /** Whether x is in the list starting at n */
    static boolean contains(Node n, Object x) {
        if (n == null) return false; // base case
        if (x.equals(n.data)) return true;
        return contains(n.next, x); // recurse on smaller list
    }
    /** Whether x is in the list starting at n. (Iterative) */
    static boolean contains(Node n, Object x) {
        while (n != null) {
            if (x.equals(n.data)) return true;
            n = n.next;
        }
        return false;
    }

    public String toString() {
        String result = "[";
        Node n = this;
        while (n != null) {
            if (n != this) result += ",";
            result += n.data;
            n = n.next;
        }
        return result + "]";
    }

    /** Sum of integers in list (recursive)*/
    int total(Node n) {
        if (n == null) return 0; // base case
        if (n.data instanceof Integer i) {
            return i + total(n.next);
        }
    }
    /** Sum of integers in list (iterative) */
    int total(Node n) {
        int sum = 0;
        while (n != null) {
            if (n.data instanceof Integer i) {
                sum = sum + i; // sum += i;
            }
            n = n.next;
        }
    }


}
