package lecture05;

import lecture04.Direction;

/** A Board that logs moves made and is 4x4 */
public class LogBoard extends ABoard {
    // inheritance
    // subtyping: LogBoard <: ABoard
    private int nmoves; // add new ivars

    LogBoard() {
        super(4); // establish superclass class invariant ~ new ABoard(4)
        nmoves = 0;

        // static: no overriding but must use superclass constructor (may be
        // implcit.

        // 1. set all ivars set to default values
        // 2. Call superclass constructor
        // 3. ivars initializers
        // 4. rest of constructor body
    }

    public int numMoves() { return nmoves; } // add new methods

    @Override // override behavior
    public boolean move(Direction d) {
        super.move(d); // calls ABoard.move()
        nmoves++;
        System.out.println("LogBoard.move()");
        return false;
    }
}