package lecture05;

import lecture04.Direction;

/** A Board is a mutable state of the 2048 game.
 *  mutable = state can change */
public interface Board {
    /** Returns: the value on the board at row r and column c,
     *  or zero if that cell is empty.
     * Requires: r and c are in the range 0-3
     */
    int value(int r, int c);
    // no constructors
    // no instance variables
    // no private methods
    /** Returns: player score */
    int score();

    /** Effect: moves the board in direction d
     *  Returns: whether the move was legal
     */
    boolean move(Direction d);
    /** Effect: reset board to empty state and 0 score */
    void reset();
}
