package lecture05;

import lecture04.Board;
import lecture04.Direction;

public class ABoard implements Board {
    /**
     * An implementation of Board using an
     * array of cells.
     */

    // Represents: a board where cells[r][c] contains the value at row r, column c
    // or zero if the cell is empty.
    // Class invariant: cells is a 4x4 array and only contains powers of two (or zero)
    // score is nonnegative
    private int[][] cells = new int[4][4];
    private int score = 0;

    ABoard(int size) {
        cells = new int[size][size];
        score = 0;
    }

    @Override
    public int value(int r, int c) {
        return cells[r][c];
    }

    @Override
    public int score() {
        return score;
    }

    @Override
    public boolean move(Direction d) {
        System.out.println("ABoard.move()");
        switch (d) {
            case UP: // ..
                break;
            case DOWN: // ...
                break;
            case LEFT: //,,.
                break;
            case RIGHT: //...
                break;
        }
        return false;
    }

    @Override
    public void reset() {

    }

    public void solve() {
        move(Direction.UP);
    }
}
