import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Main3 {
    /**
     * Given a set of target courses in `args`, print a topological ordering of those courses and
     * their prerequisites.
     */
    public static void main(String[] args) throws IOException {
        // Load course dependency database
        Iterable<Node> courseDeps = Node.readGraph("courses.txt");

        // Store targets from program arguments in a set (for fast lookup)
        Set<String> targets = new HashSet<>(Arrays.asList(args));
        // FIXME: warn if any targets are not in the dependency graph

        // Perform topological sort of prerequisite graph, keeping only nodes on path to targets
        List<Node> seq = topoSort(courseDeps, targets);

        // Print filtered topological ordering
        for (Node n : seq) {
            System.out.println(n.label());
        }
    }

    /**
     * Perform a topological sort of the graph vertices in `nodes` (need not be connected) and
     * return the subset on paths that terminate at nodes with labels in `targets`.
     * Checks: graph is acyclic.
     */
    public static List<Node> topoSort(Iterable<Node> nodes, Set<String> targets) {
        // Allocate list for assembling result (TODO: construct)
        List<Node> ans = null;

        // Create data structure(s) for storing auxiliary node data

        // For each node in the graph:
            // If n's color is white:
                // Color n gray
                // Visit n (note: this checks for cycles for us)

        return ans;
    }

    /**
     * Perform a depth-first search starting at `g`.  If a node with a label in `targets` is
     * reachable from `g`, prepend `g` to `order` and return true; otherwise, return false.
     * Checks: graph reachable from `g` is acyclic.
     */
    private static boolean dfsVisit(Node g, Set<String> targets, List<Node> order
            /* , additional parameters */) {
        // Initialize result accumulator
        boolean reachesTarget = targets.contains(g.label());

        // For each successor v of g:
            // If v's color is white:
                // Color v gray
                // Visit v (hint: and update accumulator)
            // Otherwise, if v's color is gray:
                // ERROR: graph is cyclic
            // Otherwise, v's color is black; was it on a path to a target?

        // Color g black

        // Postorder actions

        return reachesTarget;
    }
}
