import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/**
 * Run a graphical application with a keyboard-controlled "walker".
 */
public class Main {

    /**
     * Start application GUI.
     */
    public static void main(String[] args) {
        // Create application window on EDT.
        SwingUtilities.invokeLater(() -> setupGUI());

        // Wait for 8 seconds; this BLOCKS the main thread.
        try {
            Thread.sleep(8 * 1000);
        } catch (InterruptedException e) {
            System.err.println("My sleep was interrupted");
        }

        // Let user know when we are done sleeping and thread is about to exit.
        System.out.println("main thread exiting now");
    }

    /**
     * Set up the GUI and get it running. Requires: must be run from the event dispatch thread.
     */
    private static void setupGUI() {
        JFrame window = new JFrame("Walker");
        window.setSize(800, 500);

        // Reminder: Program will exit if all windows have been disposed and no other (non-daemon)
        // threads are still running.
        window.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

        // Fill window with a "box" for laying out next layer of components horizontally.
        Box hbox = new Box(BoxLayout.X_AXIS);
        window.add(hbox);

        // Place a WorldView and a Panel next to each other in the box.
        WorldView view = new WorldView();
        hbox.add(view);
        JPanel rhs = new JPanel();  // Panel goes on the "right-hand side"
        hbox.add(rhs);
        // Note: by default, a panel will lay out components horizontally with wrapping (see
        // FlowLayout).

        // Add a labeled text field and a button to the panel
        // TODO 1: Add a label describing the text field (use JLabel)
        JTextField tf = new JTextField(20);
        tf.setText("<Enter a name here>");
        // TODO 2: Make text field set the name of the "walker"
        // (Note: Pressing <ENTER> in a text field will trigger its "action".)
        tf.addActionListener(e -> {});
        rhs.add(tf);
        var quit = new JButton("Quit");
        rhs.add(quit);
        // TODO 3: Make Quit button quit the program

        // Show window (no need to pack, since we set our size manually).
        window.setVisible(true);
    }
}
