import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 * Iterator over elements in a linear or circular linked list built of CNodes.
 */
public class CNodeIterator<T> implements Iterator<T> {
    /** First node in sequence. */
    private CNode<T> firstNode;

    /** Node whose data will be returned on the next call to `next()`. */
    private CNode<T> nextNode;

    /** True if `next()` has been called at least once. */
    private boolean hasYielded;

    /** Create a new iterator starting at the specified node. */
    public CNodeIterator(CNode<T> start) {
        firstNode = start;
        nextNode = start;
        hasYielded = false;
    }

    @Override
    public boolean hasNext() {
        // Deliberately not using `equals() here - we expect to return to
        // the same node object we started from.
        return nextNode != null && (nextNode != firstNode || !hasYielded);
    }

    @Override
    public T next() throws NoSuchElementException {
        if (!hasNext()) {
            throw new NoSuchElementException();
        }
        T ans = nextNode.value;
        nextNode = nextNode.next;
        hasYielded = true;
        return ans;
    }
}
