import java.io.*;

/**
 * Print an index of words in a text file.
 */
public class Main {

    public static void main(String[] args) throws IOException {
        // Name of file to print index for
        String filename = "Austen.txt";

        // Object to build index
        Index index = new Index();

        // Read each line of the file, counting line numbers
        try (FileReader r = new FileReader(filename);
                BufferedReader br = new BufferedReader(r)) {
            int lineNum = 1;
            for (String line = br.readLine();
                    line != null;
                    line = br.readLine(), lineNum += 1) {
                // Break the line into words and index each word
                String[] tokens = line.split(" ");
                for (String word : tokens) {
                    // Convert word to canonical form (lower case)
                    index.indexWord(word.toLowerCase(), lineNum);
                }
            }
        }
        // No catch clause - we propagate the exception but close our
        // resources first

        // Print the index to the console
        index.printIndex();
    }
}
