import java.util.*;

/**
 * Class for constructing an index of words and the line numbers on which they occur.
 */
public class Index {

    // Declare and initialize field(s)
    SortedMap<String, List<Integer>> index = new TreeMap<>();

    /**
     * Add `word` to the index at line number `lineNumber`.
     */
    public void indexWord(String word, int lineNumber) {
        if (!index.containsKey(word)) {
            index.put(word, new ArrayList<Integer>());
        }
        List<Integer> lines = index.get(word);
        if (lines.isEmpty() || !lines.get(lines.size() - 1).equals(lineNumber)) {
            lines.add(lineNumber);
        }
    }

    /**
     * Print each word of the index followed by the line numbers on which it occurs.  Words are
     * printed in alphabetical order, one per line.  Line numbers are printed in numerical order
     * with no duplicates.
     */
    public void printIndex() {
        for (String word : index.keySet()) {
            System.out.print(word);
            for (Integer n : index.get(word)) {
                System.out.print(" " + n);
            }
            System.out.println();
        }
    }
}
