import java.io.BufferedReader;
import java.io.Reader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

/**
 * Read all lines using a `BufferedReader`.
 */
public class ReadLineDemo {
    public static void main(String[] args) {
        String path = "hello.txt";
        try {
            Reader in = new FileReader(path);
            BufferedReader br = new BufferedReader(in);
            String line = br.readLine();
            while (line != null) {
                System.out.println(line);
                line = br.readLine();
            }
        } catch (IOException e) {
            System.err.println("Error reading from file " + path);
            System.exit(1);
        }
        // Bug: File is never closed
    }
}
