import java.io.BufferedReader;
import java.io.Reader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

/**
 * Read all lines using a `BufferedReader`.  Close files properly.
 */
public class ClosingDemo {
    public static void main(String[] args) {
        String path = "hello.txt";
        // Try-with-resources structure
        try ( Reader in = new FileReader(path);
              BufferedReader br = new BufferedReader(in) ) {

            String line = br.readLine();
            while (line != null) {
                System.out.println(line);
                line = br.readLine();
            }

        } catch (IOException e) {
            System.err.println("Error reading from file " + path);
            System.exit(1);
        }
        // Will automatically call `br.close()`, `in.close()` at this point,
        // even if an exception is thrown.
    }
}
