/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import edu.rice.cs.plt.tuple.Option;
import java.util.List;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.MethodCall;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.SourceInfo;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticMethodCall
extends MethodCall {
    private TypeName methodType;

    public StaticMethodCall(TypeName typ, Option<List<TypeName>> targs, String mn, List<? extends Expression> args) {
        this(typ, targs, mn, args, SourceInfo.NONE);
    }

    public StaticMethodCall(TypeName typ, String mn, List<? extends Expression> args) {
        this(typ, Option.none(), mn, args, SourceInfo.NONE);
    }

    public StaticMethodCall(TypeName typ, Option<List<TypeName>> targs, String mn, List<? extends Expression> args, SourceInfo si) {
        super(targs, mn, args, si);
        if (typ == null) {
            throw new IllegalArgumentException("typ == null");
        }
        this.methodType = typ;
    }

    public StaticMethodCall(TypeName typ, String mn, List<? extends Expression> args, SourceInfo si) {
        this(typ, Option.none(), mn, args, si);
    }

    public TypeName getMethodType() {
        return this.methodType;
    }

    public void setMethodType(ReferenceTypeName t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.methodType = t;
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "(" + this.getClass().getName() + ": " + this.getTypeArgs() + " " + this.getMethodName() + " " + this.getArguments() + " " + this.getMethodType() + ")";
    }
}

