/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.text;

import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.print.DrJavaBook;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.ConsoleDocumentInterface;
import edu.rice.cs.util.text.DocumentEditCondition;
import edu.rice.cs.util.text.EditDocumentException;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.EventQueue;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ConsoleDocument
implements ConsoleDocumentInterface {
    public static final String DEFAULT_CONSOLE_PROMPT = "";
    public static final String DEFAULT_STYLE = "default";
    public static final String SYSTEM_OUT_STYLE = "System.out";
    public static final String SYSTEM_ERR_STYLE = "System.err";
    public static final String SYSTEM_IN_STYLE = "System.in";
    protected final ConsoleDocumentInterface _document;
    protected volatile Runnable _beep;
    private volatile int _promptPos;
    protected volatile String _prompt;
    protected volatile DrJavaBook _book;

    public ConsoleDocument(ConsoleDocumentInterface doc) {
        this._document = doc;
        this._beep = new Runnable(){

            @Override
            public void run() {
            }
        };
        this._prompt = DEFAULT_CONSOLE_PROMPT;
        this._promptPos = DEFAULT_CONSOLE_PROMPT.length();
        this._document.setHasPrompt(false);
        this._document.setEditCondition(new ConsoleEditCondition());
    }

    @Override
    public boolean hasPrompt() {
        return this._document.hasPrompt();
    }

    @Override
    public void setHasPrompt(boolean val) {
        this._document.setHasPrompt(val);
    }

    public String getPrompt() {
        return this._prompt;
    }

    public void setPrompt(String prompt) {
        this._prompt = prompt;
    }

    public int getPromptLength() {
        return this._prompt.length();
    }

    @Override
    public DocumentEditCondition getEditCondition() {
        return this._document.getEditCondition();
    }

    @Override
    public void setEditCondition(DocumentEditCondition condition) {
        this._document.setEditCondition(condition);
    }

    public int getPromptPos() {
        return this._promptPos;
    }

    public void setPromptPos(int newPos) {
        this._promptPos = newPos;
    }

    public void setBeep(Runnable beep) {
        this._beep = beep;
    }

    public void reset(String banner) {
        assert (EventQueue.isDispatchThread());
        try {
            this.forceRemoveText(0, this._document.getLength());
            this.forceInsertText(0, banner, DEFAULT_STYLE);
            this._promptPos = banner.length();
        }
        catch (EditDocumentException e) {
            throw new UnexpectedException(e);
        }
    }

    public void insertPrompt() {
        try {
            int len = this._document.getLength();
            this._promptPos = len + this._prompt.length();
            this.forceInsertText(len, this._prompt, DEFAULT_STYLE);
            this._document.setHasPrompt(true);
        }
        catch (EditDocumentException e) {
            throw new UnexpectedException(e);
        }
    }

    public void disablePrompt() {
        this._document.setHasPrompt(false);
        this._promptPos = this._document.getLength();
    }

    public void insertNewline(int pos) {
        try {
            int len = this._document.getLength();
            if (pos > len) {
                pos = len;
            } else if (pos < 0) {
                pos = 0;
            }
            String newLine = "\n";
            this.insertText(pos, newLine, DEFAULT_STYLE);
        }
        catch (EditDocumentException e) {
            throw new UnexpectedException(e);
        }
    }

    private int _getPositionBeforePrompt() {
        int len = this._document.getLength();
        if (this._document.hasPrompt()) {
            int promptStart = this._promptPos - this._prompt.length();
            return promptStart < len && promptStart >= 0 ? promptStart : len;
        }
        return len;
    }

    public void insertBeforeLastPrompt(String text, String style) {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        try {
            int pos = this._getPositionBeforePrompt();
            this._promptPos += text.length();
            this.forceInsertText(pos, text, style);
        }
        catch (EditDocumentException ble) {
            throw new UnexpectedException(ble);
        }
    }

    @Override
    public void insertText(int offs, String str, String style) throws EditDocumentException {
        if (offs < this._promptPos) {
            this._beep.run();
        } else {
            this._addToStyleLists(offs, str, style);
            this._document.insertText(offs, str, style);
        }
    }

    @Override
    public void append(String str, String style) throws EditDocumentException {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        int offs = this._document.getLength();
        this._addToStyleLists(offs, str, style);
        this._document.insertText(offs, str, style);
    }

    @Override
    public void forceInsertText(int offs, String str, String style) throws EditDocumentException {
        this._addToStyleLists(offs, str, style);
        this._document.forceInsertText(offs, str, style);
    }

    private void _addToStyleLists(int offs, String str, String style) {
        if (this._document instanceof SwingDocument) {
            ((SwingDocument)((Object)this._document)).addColoring(offs, offs + str.length(), style);
        }
    }

    @Override
    public void removeText(int offs, int len) throws EditDocumentException {
        if (offs < this._promptPos) {
            this._beep.run();
        } else {
            this._document.removeText(offs, len);
        }
    }

    @Override
    public void forceRemoveText(int offs, int len) throws EditDocumentException {
        this._document.forceRemoveText(offs, len);
    }

    @Override
    public int getLength() {
        return this._document.getLength();
    }

    @Override
    public String getDocText(int offs, int len) throws EditDocumentException {
        return this._document.getDocText(offs, len);
    }

    public String getText() {
        return this._document.getDocText(0, this.getLength());
    }

    public String getCurrentInput() {
        try {
            return this.getDocText(this._promptPos, this._document.getLength() - this._promptPos);
        }
        catch (EditDocumentException e) {
            throw new UnexpectedException(e);
        }
    }

    public void clearCurrentInput() {
        this._clearCurrentInputText();
    }

    protected void _clearCurrentInputText() {
        try {
            this.removeText(this._promptPos, this._document.getLength() - this._promptPos);
        }
        catch (EditDocumentException ble) {
            throw new UnexpectedException(ble);
        }
    }

    @Override
    public String getDefaultStyle() {
        return DEFAULT_STYLE;
    }

    @Override
    public Pageable getPageable() throws IllegalStateException {
        return this._book;
    }

    public void preparePrintJob() {
        this._book = new DrJavaBook(this.getDocText(0, this.getLength()), "Console", new PageFormat());
    }

    @Override
    public void print() throws PrinterException {
        this.preparePrintJob();
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPageable(this._book);
        if (printJob.printDialog()) {
            printJob.print();
        }
        this.cleanUpPrintJob();
    }

    public void cleanUpPrintJob() {
        this._book = null;
    }

    public void saveCopy(FileSaveSelector selector) throws IOException {
        assert (EventQueue.isDispatchThread());
        try {
            File file = selector.getFile().getCanonicalFile();
            if (!file.exists() || selector.verifyOverwrite(file)) {
                FileOps.saveFile(new FileOps.DefaultFileSaver(file){

                    @Override
                    public void saveTo(OutputStream os) throws IOException {
                        String text = ConsoleDocument.this.getDocText(0, ConsoleDocument.this.getLength());
                        OutputStreamWriter osw = new OutputStreamWriter(os);
                        osw.write(text, 0, text.length());
                        osw.flush();
                    }
                });
            }
        }
        catch (OperationCanceledException oce) {
            return;
        }
    }

    class ConsoleEditCondition
    extends DocumentEditCondition {
        ConsoleEditCondition() {
        }

        @Override
        public boolean canInsertText(int offs) {
            return this.canRemoveText(offs);
        }

        @Override
        public boolean canRemoveText(int offs) {
            if (offs < ConsoleDocument.this._promptPos) {
                ConsoleDocument.this._beep.run();
                return false;
            }
            return true;
        }
    }
}

