/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.config.KeyStrokeOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.VectorOption;
import edu.rice.cs.drjava.ui.config.VectorOptionComponent;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public class VectorKeyStrokeOptionComponent
extends VectorOptionComponent<KeyStroke>
implements OptionConstants,
Comparable<VectorKeyStrokeOptionComponent> {
    private static final int DIALOG_HEIGHT = 185;
    public static final HashMap<KeyStroke, VectorKeyStrokeOptionComponent> _keyToKSOC = new HashMap();

    public static void resetCurrentKeyStrokeMap() {
        HashMap<KeyStroke, VectorKeyStrokeOptionComponent> newKeyToKSOC = new HashMap<KeyStroke, VectorKeyStrokeOptionComponent>();
        for (VectorKeyStrokeOptionComponent vectorKeyStrokeOptionComponent : _keyToKSOC.values()) {
            for (KeyStroke k : vectorKeyStrokeOptionComponent.getKeyStrokes()) {
                newKeyToKSOC.put(k, vectorKeyStrokeOptionComponent);
            }
        }
        _keyToKSOC.clear();
        for (Map.Entry entry : newKeyToKSOC.entrySet()) {
            _keyToKSOC.put((KeyStroke)entry.getKey(), (VectorKeyStrokeOptionComponent)entry.getValue());
        }
    }

    public VectorKeyStrokeOptionComponent(VectorOption<KeyStroke> opt, String text, SwingFrame parent) {
        this(opt, text, parent, (String)null);
        for (KeyStroke k : this.getKeyStrokes()) {
            _keyToKSOC.put(k, this);
        }
    }

    public VectorKeyStrokeOptionComponent(VectorOption<KeyStroke> opt, String text, SwingFrame parent, String description) {
        this(opt, text, parent, description, false);
        for (KeyStroke k : this.getKeyStrokes()) {
            _keyToKSOC.put(k, this);
        }
    }

    public VectorKeyStrokeOptionComponent(VectorOption<KeyStroke> opt, String text, SwingFrame parent, String description, boolean moveButtonEnabled) {
        super(opt, text, parent, new String[0], description, moveButtonEnabled);
        for (KeyStroke k : this.getKeyStrokes()) {
            _keyToKSOC.put(k, this);
        }
    }

    @Override
    protected AbstractTableModel _makeTableModel() {
        return new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return VectorKeyStrokeOptionComponent.this._data.size();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int row, int col) {
                switch (col) {
                    case 0: {
                        return KeyStrokeOption.formatKeyStroke((KeyStroke)VectorKeyStrokeOptionComponent.this._data.get(row));
                    }
                }
                throw new IllegalArgumentException("Illegal column");
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 0: {
                        return String.class;
                    }
                }
                throw new IllegalArgumentException("Illegal column");
            }
        };
    }

    @Override
    public int compareTo(VectorKeyStrokeOptionComponent o) {
        return this.getLabelText().compareTo(o.getLabelText());
    }

    Vector<KeyStroke> getKeyStrokes() {
        return new Vector<KeyStroke>(this._data);
    }

    public void chooseKeyStroke() {
        this._table.getSelectionModel().clearSelection();
        GetKeyDialog getKeyDialog = new GetKeyDialog(this._parent, "Specify Shortcut", true);
        getKeyDialog.promptKey(KeyStrokeOption.NULL_KEYSTROKE);
    }

    @Override
    protected void _removeIndex(int i) {
        _keyToKSOC.remove(this._data.get(i));
        super._removeIndex(i);
    }

    @Override
    protected Action _getAddAction() {
        return new AbstractAction("Add"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VectorKeyStrokeOptionComponent.this.chooseKeyStroke();
            }
        };
    }

    public class GetKeyDialog
    extends JDialog {
        private InputField _inputField;
        private JButton _cancelButton;
        private JButton _okButton;
        private JLabel _instructionLabel;
        private JLabel _currentLabel;
        private JLabel _actionLabel;
        private JPanel _inputAndClearPanel;
        private JPanel _cancelAndOKPanel;
        private KeyStroke _currentKeyStroke;

        public GetKeyDialog(SwingFrame f, String title, boolean modal) {
            super(f, title, modal);
            this._inputField = new InputField();
            this._cancelButton = new JButton("Cancel");
            this._cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GetKeyDialog.this._inputField.requestFocusInWindow();
                    GetKeyDialog.this.dispose();
                }
            });
            this._okButton = new JButton("OK");
            this._okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (GetKeyDialog.this._currentKeyStroke != KeyStrokeOption.NULL_KEYSTROKE && !VectorKeyStrokeOptionComponent.this.getKeyStrokes().contains(GetKeyDialog.this._currentKeyStroke)) {
                        VectorKeyStrokeOptionComponent conflict = _keyToKSOC.get(GetKeyDialog.this._currentKeyStroke);
                        if (conflict != null) {
                            Vector<KeyStroke> v = conflict.getKeyStrokes();
                            v.removeElement(GetKeyDialog.this._currentKeyStroke);
                            conflict.setValue(v);
                        }
                        _keyToKSOC.put(GetKeyDialog.this._currentKeyStroke, VectorKeyStrokeOptionComponent.this);
                        VectorKeyStrokeOptionComponent.this._addValue(GetKeyDialog.this._currentKeyStroke);
                    }
                    GetKeyDialog.this._inputField.requestFocusInWindow();
                    GetKeyDialog.this.dispose();
                }
            });
            this._instructionLabel = new JLabel("Type in the keystroke you want to use and click \"OK\"");
            this._currentLabel = new JLabel("Current action bound to the keystroke:");
            this._actionLabel = new JLabel("<none>");
            this._inputAndClearPanel = new JPanel(new BorderLayout());
            this._inputAndClearPanel.add((Component)this._inputField, "Center");
            this._cancelAndOKPanel = new JPanel(new GridLayout(1, 0));
            this._cancelAndOKPanel.add(this._okButton);
            this._cancelAndOKPanel.add(this._cancelButton);
            JPanel panel = (JPanel)this.getContentPane();
            panel.setLayout(new GridLayout(0, 1));
            panel.add(this._instructionLabel);
            panel.add(this._inputAndClearPanel);
            panel.add(this._currentLabel);
            panel.add(this._actionLabel);
            panel.add(this._cancelAndOKPanel);
            this.setSize((int)this._instructionLabel.getPreferredSize().getWidth() + 30, 185);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GetKeyDialog.this.pack();
                }
            });
        }

        public void promptKey(KeyStroke initial) {
            this._instructionLabel.setText("Type in the keystroke you want to use for \"" + VectorKeyStrokeOptionComponent.this.getLabelText() + "\" and click \"OK\"");
            this._currentKeyStroke = initial;
            this._actionLabel.setText(VectorKeyStrokeOptionComponent.this.getLabelText());
            this._inputField.setText(KeyStrokeOption.formatKeyStroke(this._currentKeyStroke));
            this.setSize((int)this._instructionLabel.getPreferredSize().getWidth() + 30, 185);
            Utilities.setPopupLoc(this, this.getOwner());
            this.setVisible(true);
        }

        private class InputField
        extends JTextField {
            private InputField() {
            }

            @Override
            public void processKeyEvent(KeyEvent e) {
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if (e.getID() == 401) {
                    this.setText(KeyStrokeOption.formatKeyStroke(ks));
                    VectorKeyStrokeOptionComponent configKs = _keyToKSOC.get(ks);
                    if (configKs == null) {
                        GetKeyDialog.this._actionLabel.setText("<none>");
                    } else {
                        String name = configKs.getLabelText();
                        GetKeyDialog.this._actionLabel.setText(name);
                    }
                    GetKeyDialog.this._currentKeyStroke = ks;
                }
            }
        }
    }
}

