/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.drjava.model.repl.SimpleInteractionsModel;
import edu.rice.cs.drjava.ui.InteractionsController;
import edu.rice.cs.drjava.ui.InteractionsPane;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.swing.SwingFrame;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JScrollPane;

public class SimpleInteractionsWindow
extends SwingFrame {
    private final SimpleInteractionsModel _model;
    private final InteractionsDJDocument _adapter;
    private final InteractionsPane _pane;
    private final InteractionsController _controller;

    public SimpleInteractionsWindow() {
        this("Interactions Window");
    }

    public SimpleInteractionsWindow(String title) {
        super(title);
        this.setSize(600, 400);
        this._adapter = new InteractionsDJDocument();
        this._model = new SimpleInteractionsModel(this._adapter);
        this._pane = new InteractionsPane(this._adapter){

            @Override
            public int getPromptPos() {
                return SimpleInteractionsWindow.this._model.getDocument().getPromptPos();
            }
        };
        this._controller = new InteractionsController(this._model, this._adapter, this._pane, new Runnable(){

            @Override
            public void run() {
            }
        });
        this._pane.setFont(Font.decode("monospaced"));
        this._model.addListener(new InteractionsListener(){

            @Override
            public void interactionStarted() {
                SimpleInteractionsWindow.this._pane.setEditable(false);
            }

            @Override
            public void interactionEnded() {
                SimpleInteractionsWindow.this._controller.moveToPrompt();
                SimpleInteractionsWindow.this._pane.setEditable(true);
            }

            @Override
            public void interpreterResetting() {
                SimpleInteractionsWindow.this._pane.setEditable(false);
            }

            @Override
            public void interactionErrorOccurred(int offset, int length) {
                SimpleInteractionsWindow.this._pane.highlightError(offset, length);
            }

            @Override
            public void interpreterReady(File wd) {
                SimpleInteractionsWindow.this._controller.moveToPrompt();
                SimpleInteractionsWindow.this._pane.setEditable(true);
            }

            @Override
            public void interpreterExited(int status) {
            }

            @Override
            public void interpreterChanged(boolean inProgress) {
                SimpleInteractionsWindow.this._pane.setEditable(inProgress);
            }

            @Override
            public void interpreterResetFailed(Throwable t) {
                this.interpreterReady(FileOps.NULL_FILE);
            }

            @Override
            public void interactionIncomplete() {
                int caretPos = SimpleInteractionsWindow.this._pane.getCaretPosition();
                SimpleInteractionsWindow.this._controller.getConsoleDoc().insertNewline(caretPos);
            }
        });
        JScrollPane scroll = new JScrollPane(this._pane);
        this.getContentPane().add(scroll);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                SimpleInteractionsWindow.this.close();
            }
        });
        this.initDone();
    }

    protected void close() {
        System.exit(0);
    }

    public InteractionsController getController() {
        return this._controller;
    }

    public static void main(String[] args) {
        SimpleInteractionsWindow w = new SimpleInteractionsWindow();
        if (args.length <= 0 || args[0].equals("-debug")) {
            // empty if block
        }
        w.setVisible(true);
    }
}

