/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionParser;
import edu.rice.cs.drjava.config.StringOption;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.config.ConfigDescriptions;
import edu.rice.cs.drjava.ui.config.VectorOptionComponent;
import edu.rice.cs.drjava.ui.predictive.PredictiveInputFrame;
import edu.rice.cs.drjava.ui.predictive.PredictiveInputModel;
import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class ProjectAdvancedPropertiesFrame
extends SwingFrame {
    private static final int FRAME_WIDTH = 503;
    private static final int FRAME_HEIGHT = 500;
    private MainFrame _mainFrame;
    private SwingFrame _parentFrame;
    private SingleDisplayModel _model;
    private VectorOptionComponent<PreferencesRecord> _preferencesList;
    private volatile Map<OptionParser<?>, String> _unmodifiedStoredPreferences = new HashMap();
    public static final PredictiveInputModel<PreferencesRecord> STORED_PROPERTIES_PIM = new PredictiveInputModel(true, new PredictiveInputModel.FragmentStrategy(), (Comparable[])new PreferencesRecord[0]);
    private final JButton _okButton;
    private final JButton _cancelButton;
    private JPanel _mainPanel;
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            ProjectAdvancedPropertiesFrame.this.cancel();
        }
    };

    public ProjectAdvancedPropertiesFrame(MainFrame mf, SwingFrame parentFrame) {
        super("Advanced Project Properties");
        this._parentFrame = parentFrame;
        this._mainFrame = mf;
        this._model = this._mainFrame.getModel();
        this._mainPanel = new JPanel();
        AbstractAction okAction = new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean successful = true;
                ProjectAdvancedPropertiesFrame.this.setVisible(false);
            }
        };
        this._okButton = new JButton(okAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectAdvancedPropertiesFrame.this.cancel();
            }
        };
        this._cancelButton = new JButton(cancelAction);
        this.init();
        this.initDone();
    }

    private void init() {
        this._setupPanel(this._mainPanel);
        JScrollPane scrollPane = new JScrollPane(this._mainPanel);
        Container cp = this.getContentPane();
        GridBagLayout cpLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        cp.setLayout(cpLayout);
        c.fill = 1;
        c.anchor = 11;
        c.gridwidth = 0;
        c.gridheight = -1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        cpLayout.setConstraints(scrollPane, c);
        cp.add(scrollPane);
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        bottom.add(Box.createHorizontalGlue());
        c.fill = 0;
        c.anchor = 15;
        c.gridheight = 0;
        c.weighty = 0.0;
        cpLayout.setConstraints(bottom, c);
        cp.add(bottom);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        dim.width = dim.width > 503 ? 503 : (dim.width -= 80);
        dim.height = dim.height > 500 ? 500 : (dim.height -= 80);
        this.setSize(dim);
        Utilities.setPopupLoc(this, this._parentFrame);
    }

    public void cancel() {
        this.reset();
        this.setVisible(false);
    }

    public void reset() {
        this.setPreferencesStoredInProject(this._unmodifiedStoredPreferences);
    }

    public void reset(Map<OptionParser<?>, String> sp) {
        this._unmodifiedStoredPreferences = new HashMap(sp);
        this.setPreferencesStoredInProject(this._unmodifiedStoredPreferences);
    }

    public Map<OptionParser<?>, String> getPreferencesStoredInProject() {
        HashMap sp = new HashMap();
        for (PreferencesRecord pr : this._preferencesList.getValue()) {
            sp.put(pr.option, DrJava.getConfig().getOptionMap().getString(pr.option));
        }
        return sp;
    }

    public void setPreferencesStoredInProject(Map<OptionParser<?>, String> sp) {
        ArrayList<PreferencesRecord> list = new ArrayList<PreferencesRecord>();
        for (OptionParser<?> o : sp.keySet()) {
            list.add(new PreferencesRecord(o, ConfigDescriptions.CONFIG_DESCRIPTIONS.get(o), ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o)));
        }
        this._preferencesList.setValue(list);
    }

    private void _setupPanel(JPanel panel) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 2;
        Insets labelInsets = new Insets(5, 10, 0, 0);
        Insets compInsets = new Insets(5, 5, 0, 10);
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.insets = labelInsets;
        JLabel descriptionLabel = new JLabel("<html>The current values of the preferences listed here will be<br>stored in the project file when the project is saved and<br> restored when the project is loaded again.<br>Note that the previous values of preferences stored in a project<br>file will be overwritten when a project is loaded.<br>&nbsp;</html>");
        gridbag.setConstraints(descriptionLabel, c);
        panel.add(descriptionLabel);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel preferencesLabel = new JLabel("Stored Preferences");
        preferencesLabel.setToolTipText("<html>The list of preferences that are stored and restored with the project.</html>");
        gridbag.setConstraints(preferencesLabel, c);
        panel.add(preferencesLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = compInsets;
        Component preferencesComponent = this._preferencesComponent();
        gridbag.setConstraints(preferencesComponent, c);
        panel.add(preferencesComponent);
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.insets = labelInsets;
        descriptionLabel = new JLabel("<html>To change the preferences, please use the 'Preferences' window<br>in the 'Edit' menu.</html>");
        gridbag.setConstraints(descriptionLabel, c);
        panel.add(descriptionLabel);
    }

    public Component _preferencesComponent() {
        this._preferencesList = new VectorOptionComponent<PreferencesRecord>(null, "Stored Preferences", (SwingFrame)this, new String[0], "The list of preferences that are stored and restored with the project.", false){

            @Override
            protected Action _getAddAction() {
                return new AbstractAction("Add"){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ProjectAdvancedPropertiesFrame.this._mainFrame.removeModalWindowAdapter(ProjectAdvancedPropertiesFrame.this);
                        this.chooseString();
                    }
                };
            }

            public void chooseString() {
                new Thread(){

                    @Override
                    public void run() {
                        final CompletionMonitor cm = new CompletionMonitor();
                        PredictiveInputFrame.InfoSupplier<PreferencesRecord> info = new PredictiveInputFrame.InfoSupplier<PreferencesRecord>(){

                            @Override
                            public String value(PreferencesRecord entry) {
                                return entry.longDesc;
                            }
                        };
                        PredictiveInputFrame.CloseAction<PreferencesRecord> okAction = new PredictiveInputFrame.CloseAction<PreferencesRecord>(){

                            @Override
                            public String getName() {
                                return "OK";
                            }

                            @Override
                            public KeyStroke getKeyStroke() {
                                return KeyStroke.getKeyStroke(10, 0);
                            }

                            @Override
                            public String getToolTipText() {
                                return null;
                            }

                            @Override
                            public Object value(PredictiveInputFrame<PreferencesRecord> p) {
                                if (p.getItem() != null) {
                                    this._addValue(p.getItem());
                                }
                                cm.signal();
                                return null;
                            }
                        };
                        PredictiveInputFrame.CloseAction<PreferencesRecord> cancelAction = new PredictiveInputFrame.CloseAction<PreferencesRecord>(){

                            @Override
                            public String getName() {
                                return "Cancel";
                            }

                            @Override
                            public KeyStroke getKeyStroke() {
                                return KeyStroke.getKeyStroke(27, 0);
                            }

                            @Override
                            public String getToolTipText() {
                                return null;
                            }

                            @Override
                            public Object value(PredictiveInputFrame<PreferencesRecord> p) {
                                cm.signal();
                                return null;
                            }
                        };
                        ArrayList strategies = new ArrayList();
                        strategies.add(new PredictiveInputModel.FragmentStrategy());
                        strategies.add(new PredictiveInputModel.PrefixStrategy());
                        strategies.add(new PredictiveInputModel.RegExStrategy());
                        ArrayList<PredictiveInputFrame.CloseAction<PreferencesRecord>> actions = new ArrayList<PredictiveInputFrame.CloseAction<PreferencesRecord>>();
                        actions.add(okAction);
                        actions.add(cancelAction);
                        final PredictiveInputFrame pif = new PredictiveInputFrame((SwingFrame)ProjectAdvancedPropertiesFrame.this, "Preferences Stored with Project", true, true, (PredictiveInputFrame.InfoSupplier)info, strategies, actions, 1, (Comparable[])new PreferencesRecord[]{new PreferencesRecord(new StringOption("dummy", "dummy"), "dummy", "dummy")});
                        pif.setModel(true, STORED_PROPERTIES_PIM);
                        Utilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                pif.setVisible(true);
                            }
                        });
                        cm.attemptEnsureSignaled();
                        Utilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProjectAdvancedPropertiesFrame.this._mainFrame.installModalWindowAdapter(ProjectAdvancedPropertiesFrame.this, LambdaUtil.NO_OP, ProjectAdvancedPropertiesFrame.this.CANCEL);
                            }
                        });
                    }
                }.start();
            }
        };
        this._preferencesList.setRows(15, 15);
        return this._preferencesList.getComponent();
    }

    @Override
    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            this._mainFrame.hourglassOn();
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
            this.toFront();
        } else {
            this._mainFrame.removeModalWindowAdapter(this);
            this._mainFrame.hourglassOff();
            this._parentFrame.toFront();
        }
        super.setVisible(vis);
    }

    static {
        ArrayList<PreferencesRecord> list = new ArrayList<PreferencesRecord>();
        for (Map.Entry<OptionParser<?>, String> e : ConfigDescriptions.CONFIG_DESCRIPTIONS.entrySet()) {
            OptionParser<?> o = e.getKey();
            String shortDesc = e.getValue();
            String longDesc = ConfigDescriptions.CONFIG_LONG_DESCRIPTIONS.get(o);
            list.add(new PreferencesRecord(o, shortDesc, longDesc));
        }
        STORED_PROPERTIES_PIM.setItems(list.toArray(new PreferencesRecord[list.size()]));
    }

    protected static class PreferencesRecord
    implements Comparable<PreferencesRecord> {
        public final OptionParser<?> option;
        public final String shortDesc;
        public final String longDesc;

        public PreferencesRecord(OptionParser<?> o, String s, String l) {
            this.option = o;
            this.shortDesc = s;
            this.longDesc = StringOps.removeHTML(l);
        }

        @Override
        public int compareTo(PreferencesRecord other) {
            return this.option.getName().compareTo(other.option.getName());
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof PreferencesRecord)) {
                return false;
            }
            PreferencesRecord o = (PreferencesRecord)other;
            return this.option.getName().equals(o.option.getName());
        }

        public int hashCode() {
            return this.option.getName().hashCode();
        }

        public String toString() {
            return this.shortDesc;
        }
    }
}

