/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug.jpda;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.StepRequest;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.jpda.DebugAction;
import edu.rice.cs.drjava.model.debug.jpda.JPDADebugger;
import java.util.Vector;

public class Step
extends DebugAction<StepRequest>
implements OptionConstants {
    private final ThreadReference _thread;
    private final int _size;
    private final int _depth;
    private final String[] _javaExcludes = new String[]{"java.*", "javax.*", "sun.*", "com.sun.*", "com.apple.eawt.*", "com.apple.eio.*"};

    public Step(JPDADebugger manager, int size, int depth) throws DebugException, IllegalStateException {
        super(manager);
        this._suspendPolicy = 1;
        this._thread = this._manager.getCurrentThread();
        this._size = size;
        this._depth = depth;
        this._countFilter = 1;
        this._initializeRequests();
    }

    @Override
    protected void _createRequests() throws DebugException {
        boolean stepJava = DrJava.getConfig().getSetting(DEBUG_STEP_JAVA);
        boolean stepInterpreter = DrJava.getConfig().getSetting(DEBUG_STEP_INTERPRETER);
        boolean stepDrJava = DrJava.getConfig().getSetting(DEBUG_STEP_DRJAVA);
        StepRequest request = this._manager.getEventRequestManager().createStepRequest(this._thread, this._size, this._depth);
        if (!stepJava) {
            for (int i = 0; i < this._javaExcludes.length; ++i) {
                request.addClassExclusionFilter(this._javaExcludes[i]);
            }
        }
        if (!stepInterpreter) {
            request.addClassExclusionFilter("koala.*");
            request.addClassExclusionFilter("edu.rice.cs.dynamicjava.*");
        }
        if (!stepDrJava) {
            request.addClassExclusionFilter("edu.rice.cs.drjava.*");
            request.addClassExclusionFilter("edu.rice.cs.util.*");
            request.addClassExclusionFilter("edu.rice.cs.plt.*");
        }
        for (String s : (Vector)DrJava.getConfig().getSetting(DEBUG_STEP_EXCLUDE)) {
            request.addClassExclusionFilter(s.trim());
        }
        this._requests.add(request);
    }

    public String toString() {
        return "Step[thread: " + this._thread + "]";
    }
}

