/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.Configuration;
import edu.rice.cs.drjava.config.DefaultOptionMap;
import edu.rice.cs.drjava.config.FormatStrategy;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.config.OptionParser;
import edu.rice.cs.util.swing.Utilities;
import java.util.HashMap;
import java.util.Vector;

public abstract class Option<T>
extends OptionParser<T>
implements FormatStrategy<T> {
    final HashMap<Configuration, Vector<OptionListener<T>>> listeners = new HashMap();

    public Option(String name, T def) {
        super(name, def);
    }

    @Override
    public String format(T value) {
        return value.toString();
    }

    @Override
    public String getDefaultString() {
        return this.format(this.getDefault());
    }

    @Override
    String getString(DefaultOptionMap om) {
        return this.format(this.getOption(om));
    }

    synchronized void notifyListeners(Configuration config, T val) {
        final Vector<OptionListener<T>> v = this.listeners.get(config);
        if (v == null) {
            return;
        }
        final OptionEvent<T> e = new OptionEvent<T>(this, val);
        Utilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < v.size(); ++i) {
                    ((OptionListener)v.get(i)).optionChanged(e);
                }
            }
        });
    }

    synchronized void addListener(Configuration c, OptionListener<T> l) {
        Vector<OptionListener<Object>> v = this.listeners.get(c);
        if (v == null) {
            v = new Vector();
            this.listeners.put(c, v);
        }
        v.add(l);
    }

    synchronized void removeListener(Configuration c, OptionListener<T> l) {
        Vector<OptionListener<T>> v = this.listeners.get(c);
        if (v != null && v.remove(l) && v.size() == 0) {
            this.listeners.remove(c);
        }
    }
}

