/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.code.instructions;

import edu.rice.cs.cunit.classFile.code.Opcode;
import edu.rice.cs.cunit.classFile.code.instructions.AInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.util.Types;

public class BranchInstruction
extends AInstruction {
    protected byte _opcode;
    protected int _target;

    public BranchInstruction(byte opcode, int target) {
        switch (opcode) {
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -89: 
            case -88: 
            case -58: 
            case -57: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid branch opcode");
            }
        }
        this._opcode = opcode;
        this._target = target;
    }

    public byte getOpcode() {
        return this._opcode;
    }

    public int getBytecodeLength(int pc) {
        return 3;
    }

    public BranchInstruction(byte[] bytecode, int pc, int paddingPC, LineNumberTable lnt) {
        this._opcode = bytecode[pc];
        this._target = lnt.getLineNumber(pc + Types.shortFromBytes(bytecode, pc + 1));
    }

    public byte[] getBytecode(int pc, LineNumberTable lnt) {
        byte[] b = new byte[this.getBytecodeLength(pc)];
        b[0] = this.getOpcode();
        Types.bytesFromShort((short)(lnt.getPC(this._target) - pc), b, 1);
        return b;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BranchInstruction)) {
            return false;
        }
        BranchInstruction branchInstruction = (BranchInstruction)o;
        if (this._opcode != branchInstruction._opcode) {
            return false;
        }
        return this._target == branchInstruction._target;
    }

    public int hashCode() {
        int result = this._opcode;
        result = 29 * result + this._target;
        return result;
    }

    public int[] getBranchTargets() {
        return new int[]{this._target};
    }

    public void setBranchTargets(int[] branchTargets) {
        if (branchTargets.length != 1) {
            throw new IllegalArgumentException("Branch instruction can only have one target");
        }
        this._target = branchTargets[0];
    }

    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(Opcode.getOpcodeName(this._opcode));
        x.append(" ");
        x.append(this._target);
        return x.toString();
    }
}

