/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.visitors.IAttributeVisitor;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.util.Types;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeAttributeInfo
extends AAttributeInfo {
    protected CodeProperties _props = null;

    public CodeAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) throws ClassFormatError {
        super(name, data, cp);
    }

    public CodeAttributeInfo(AUTFPoolInfo name, int maxStack, int maxLocals, byte[] code, ExceptionTableEntry[] exceptionTableEntries, AAttributeInfo[] attributes, ConstantPool cp) throws ClassFormatError, IOException {
        super(name, null, cp);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeShort(maxStack);
        dos.writeShort(maxLocals);
        dos.writeInt(0);
        dos.writeShort(0);
        dos.writeShort(0);
        this.setData(bos.toByteArray());
        this.setCode(code);
        this.setExceptionTableEntries(exceptionTableEntries);
        this.setAttributes(attributes);
    }

    @Override
    public void setData(byte[] data) {
        this._props = null;
        super.setData(data);
    }

    public CodeProperties getProperties() throws ClassFormatError {
        if (this._props == null) {
            int maxStack = Types.ushortFromBytes(this._data, 0);
            int maxLocals = Types.ushortFromBytes(this._data, 2);
            int codeLength = Types.uintFromBytes(this._data, 4);
            int exceptionTableLength = Types.ushortFromBytes(this._data, 8 + codeLength);
            int attributesCount = Types.ushortFromBytes(this._data, 10 + codeLength + 8 * exceptionTableLength);
            this._props = new CodeProperties(maxStack, maxLocals, codeLength, exceptionTableLength, attributesCount);
        }
        return new CodeProperties(this._props.maxStack, this._props.maxLocals, this._props.codeLength, this._props.exceptionTableLength, this._props.attributesCount);
    }

    public void setProperties(int maxStack, int maxLocals) {
        assert (maxStack <= 65535);
        assert (maxLocals <= 65535);
        this.getProperties();
        this._props.maxStack = maxStack;
        this._props.maxLocals = maxLocals;
        Types.bytesFromShort((short)(maxStack & 0xFFFF), this._data, 0);
        Types.bytesFromShort((short)(maxLocals & 0xFFFF), this._data, 2);
    }

    public byte[] getCode() {
        this.getProperties();
        byte[] b = new byte[this._props.codeLength];
        System.arraycopy(this._data, 8, b, 0, this._props.codeLength);
        return b;
    }

    public void setCode(byte[] code) throws IllegalArgumentException {
        if (code.length == 0) {
            throw new IllegalArgumentException("Code block cannot be empty");
        }
        this.getProperties();
        byte[] newData = new byte[this._data.length - this._props.codeLength + code.length];
        System.arraycopy(this._data, 0, newData, 0, 4);
        Types.bytesFromInt(code.length, newData, 4);
        System.arraycopy(code, 0, newData, 8, code.length);
        System.arraycopy(this._data, 8 + this._props.codeLength, newData, 8 + code.length, this._data.length - 8 - this._props.codeLength);
        this.setData(newData);
    }

    public ExceptionTableEntry[] getExceptionTableEntries() {
        this.getProperties();
        ExceptionTableEntry[] e = new ExceptionTableEntry[this._props.exceptionTableLength];
        int i = 0;
        int index = 10 + this._props.codeLength;
        while (i < this._props.exceptionTableLength) {
            int startPC = Types.ushortFromBytes(this._data, index);
            int endPC = Types.ushortFromBytes(this._data, index + 2);
            int handlerPC = Types.ushortFromBytes(this._data, index + 4);
            int catchType = Types.ushortFromBytes(this._data, index + 6);
            e[i] = new ExceptionTableEntry(startPC, endPC, handlerPC, catchType);
            ++i;
            index += 8;
        }
        return e;
    }

    public void setExceptionTableEntries(ExceptionTableEntry[] e) throws IllegalArgumentException {
        if (e.length > 65535) {
            throw new IllegalArgumentException("Too many exception table entries, max=0xffff");
        }
        this.getProperties();
        byte[] newData = new byte[this._data.length - 8 * this._props.exceptionTableLength + 8 * e.length];
        System.arraycopy(this._data, 0, newData, 0, 8 + this._props.codeLength);
        Types.bytesFromShort((short)e.length, newData, 8 + this._props.codeLength);
        for (int i = 0; i < e.length; ++i) {
            Types.bytesFromShort((short)(e[i].startPC & 0xFFFF), newData, 10 + this._props.codeLength + i * 8);
            Types.bytesFromShort((short)(e[i].endPC & 0xFFFF), newData, 12 + this._props.codeLength + i * 8);
            Types.bytesFromShort((short)(e[i].handlerPC & 0xFFFF), newData, 14 + this._props.codeLength + i * 8);
            Types.bytesFromShort((short)(e[i].catchType & 0xFFFF), newData, 16 + this._props.codeLength + i * 8);
        }
        System.arraycopy(this._data, 10 + this._props.codeLength + 8 * this._props.exceptionTableLength, newData, 10 + this._props.codeLength + 8 * e.length, this._data.length - 10 - this._props.codeLength - 8 * this._props.exceptionTableLength);
        this.setData(newData);
    }

    public AAttributeInfo[] getAttributes() throws ClassFormatError {
        this.getProperties();
        AAttributeInfo[] a = new AAttributeInfo[this._props.attributesCount];
        byte[] b = new byte[this._data.length - 12 - this._props.codeLength - 8 * this._props.exceptionTableLength];
        System.arraycopy(this._data, 12 + this._props.codeLength + 8 * this._props.exceptionTableLength, b, 0, b.length);
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
            for (int i = 0; i < this._props.attributesCount; ++i) {
                a[i] = AAttributeInfo.read(dis, this._constantPool);
            }
        }
        catch (IOException e) {
            throw new ClassFormatError("Could not get code attributes");
        }
        return a;
    }

    public void setAttributes(AAttributeInfo[] a) throws ClassFormatError, IllegalArgumentException {
        if (a.length > 65535) {
            throw new IllegalArgumentException("Too many atttributes, max=0xffff");
        }
        this.getProperties();
        byte[] newData = new byte[]{};
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            for (AAttributeInfo attr : a) {
                attr.write(dos);
            }
            byte[] attr = baos.toByteArray();
            newData = new byte[12 + this._props.codeLength + 8 * this._props.exceptionTableLength + attr.length];
            System.arraycopy(this._data, 0, newData, 0, 10 + this._props.codeLength + 8 * this._props.exceptionTableLength);
            Types.bytesFromShort((short)a.length, newData, 10 + this._props.codeLength + 8 * this._props.exceptionTableLength);
            System.arraycopy(attr, 0, newData, newData.length - attr.length, attr.length);
        }
        catch (IOException e) {
            throw new ClassFormatError("Cannot set code attributes");
        }
        this.setData(newData);
    }

    @Override
    public <R, D> R execute(IAttributeVisitor<R, D> visitor, D param) {
        return visitor.codeCase(this, param);
    }

    @Override
    public String toString() {
        this.getProperties();
        StringBuilder x = new StringBuilder();
        x.append("Code <" + this._data.length + " bytes, " + this._props.maxStack + " max stack, " + this._props.maxLocals + " max locals, " + this._props.codeLength + " code bytes, " + this._props.exceptionTableLength + " exception table entries { ");
        for (ExceptionTableEntry e : this.getExceptionTableEntries()) {
            x.append("(pc=" + e.startPC + ".." + e.endPC + " handler=" + e.handlerPC + " type=" + e.catchType + ") ");
        }
        x.append("}, " + this._props.attributesCount + " attributes = { ");
        boolean first = true;
        for (AAttributeInfo a : this.getAttributes()) {
            if (first) {
                first = false;
            } else {
                x.append(", ");
            }
            x.append(a.toString());
        }
        x.append("} >");
        return x.toString();
    }

    @Override
    public void adjustPC(int startPC, int deltaPC) {
        AAttributeInfo[] attributes;
        ExceptionTableEntry[] exceptions;
        for (ExceptionTableEntry exc : exceptions = this.getExceptionTableEntries()) {
            if (exc.startPC >= startPC) {
                exc.startPC += deltaPC;
            }
            if (exc.endPC >= startPC) {
                exc.endPC += deltaPC;
            }
            if (exc.handlerPC < startPC) continue;
            exc.handlerPC += deltaPC;
        }
        this.setExceptionTableEntries(exceptions);
        for (AAttributeInfo attr : attributes = this.getAttributes()) {
            attr.adjustPC(startPC, deltaPC);
        }
        this.setAttributes(attributes);
    }

    @Override
    public void translatePC(int index, int deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
        AAttributeInfo[] attributes;
        ExceptionTableEntry[] exceptions;
        for (ExceptionTableEntry exc : exceptions = this.getExceptionTableEntries()) {
            int oldLineNo;
            exc.startPC = newLnt.getPC(oldLineNo += (oldLineNo = oldLnt.getLineNumber(exc.startPC)) > index ? deltaIndex : 0);
            oldLineNo = oldLnt.getLineNumber(exc.endPC);
            exc.endPC = newLnt.getPC(oldLineNo += oldLineNo > index ? deltaIndex : 0);
            oldLineNo = oldLnt.getLineNumber(exc.handlerPC);
            exc.handlerPC = newLnt.getPC(oldLineNo += oldLineNo > index ? deltaIndex : 0);
        }
        this.setExceptionTableEntries(exceptions);
        for (AAttributeInfo attr : attributes = this.getAttributes()) {
            attr.translatePC(index, deltaIndex, oldLnt, newLnt);
        }
        this.setAttributes(attributes);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static String getAttributeName() {
        return "Code";
    }

    public static class ExceptionTableEntry {
        public int startPC;
        public int endPC;
        public int handlerPC;
        public int catchType;

        public ExceptionTableEntry(int startPC, int endPC, int handlerPC, int catchType) {
            this.startPC = startPC;
            this.endPC = endPC;
            this.handlerPC = handlerPC;
            this.catchType = catchType;
        }
    }

    public static class CodeProperties {
        public int maxStack;
        public int maxLocals;
        public int codeLength;
        public int exceptionTableLength;
        public int attributesCount;

        public CodeProperties(int maxStack, int maxLocals, int codeLength, int exceptionTableLength, int attributesCount) {
            this.maxStack = maxStack;
            this.maxLocals = maxLocals;
            this.codeLength = codeLength;
            this.exceptionTableLength = exceptionTableLength;
            this.attributesCount = attributesCount;
        }
    }
}

