
/** example of diff between notify() and notifyAll().<br>
 * From stackoverflow.com/questions/37026/java-notify-vs-notifyall-all-over-again
 */
import java.util.Random;

/** An instance is a consumer that consumes integers from a bounded buffer. <br>
 * It consumes either even integers or odd integers, but not both. <br>
 * It sleeps for a random amount of time between getting integers */
public class Consumer implements Runnable {

	private final Dropbox dropbox; // The buffer from which to take values
	private final boolean even;    // Take even values iff even is true

	/** Constructor: An instance take values from buffer dropbox. <br>
	 * It takes even values iff even is true. */
	public Consumer(boolean even, Dropbox d) {
		this.even= even;
		dropbox= d;
	}

	/** Forever: Get a value of the right kind from the buffer and <br>
	 * then sleep for a random amount of time (in 0..99). */
	@Override
	public void run() {
		Random random= new Random();
		while (true) {
			dropbox.take(even);
			try {
				Thread.sleep(random.nextInt(5000));
			} catch (InterruptedException e) {}
		}
	}
}