/** An instance maintains a bounded buffer of limited size */
class BoundedBuffer<E> {
    ArrayQueue<E> aq;  // bounded buffer is implemented in aq

    /** Constructor: An empty buffer of max size n */
    public BoundedBuffer(int n) {
        aq= new ArrayQueue<E>(n);
    }

    /** Put v into the bounded buffer */
    public synchronized void produce(E v) {
        while (aq.isFull())
            try {
                wait();
            } catch (InterruptedException e) {
            }
        aq.put(v);
        notifyAll();
    }
    
    /** Remove first element from bounded buffer and return it. */
    public synchronized E consume() {
        while (aq.isEmpty())
            try {
                wait();
            } catch (InterruptedException e) {
            }
        E item= aq.take();
        notifyAll();
        return item;
    }
}
