import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class ArrayQueueTest {

	@Test
	public void testEmpty() {
		@SuppressWarnings("rawtypes")
		ArrayQueue q= new ArrayQueue(5);
		assertEquals(0, q.size());
	}

	@Test
	public void testPushAndPop() {
		ArrayQueue<Integer> q= new ArrayQueue<>(5);
		q.put(5);
		assertEquals(1, q.size());
		assertEquals(new Integer(5), q.peek());
		assertEquals(1, q.size());
		assertEquals(new Integer(5), q.take());
		assertEquals(0, q.size());
	}

	@Test
	public void testAdding1AtATime() {
		ArrayQueue<Integer> q= new ArrayQueue<>(5);
		for (int k= 0; k < 10; k= k + 1) {
			q.put(k);
			assertEquals(1, q.size());
			assertEquals(new Integer(k), q.take());
			assertEquals(0, q.size());
		}
	}

}
