/** An instance implements a queue of bounded size in an array */
public class ArrayQueue<E> {
	private E[] b; // The n elements of the queue are in
	private int n; // b[h], b[h+1], ... b[h+n-1] ( all indexes mod b.length)
	private int h; // 0 <= h < b.length

	/** Constructor: a queue of maximum size s. */
	@SuppressWarnings("unchecked")
	public ArrayQueue(int s) {
		b= (E[]) new Object[s];
	}

	/** Return the size of the queue. */
	public int size() {
		return n;
	}

	/** = "queue is empty" */
	public boolean isEmpty() {
		return n == 0;
	}

	/** = "queue is full */
	public boolean isFull() {
		return n == b.length;
	}

	/** Throw RuntimeExpection if q is full. Otherwise, add e to the queue. */
	public void put(E e) {
		if (n == b.length) throw new RuntimeException("queue full");
		b[(h + n) % b.length]= e;
		n= n + 1;
	}

	/** Throw a RuntimeException if q is empty. <br>
	 * Otherwise, return first element of the queue. */
	public E peek() {
		if (n == 0) throw new RuntimeException("queue empty");
		return b[h];
	}

	/** Throw a RuntimeException if the queue is empty. <br>
	 * Otherwise, take head of queue off queue and return it. */
	public E take() {
		if (n == 0) throw new RuntimeException("queue empty");
		E e= b[h];
		h= (h + 1) % b.length;
		n= n - 1;
		return e;
	}

}
