import java.util.List;
import java.util.LinkedList;

public class J_BinarySearch {
  public static void main(String[] args) {
    // This is a sorted list.
    List<Integer> numbers = new LinkedList<Integer>();
    numbers.add(0);
    numbers.add(1);
    numbers.add(2);
    numbers.add(42);
    numbers.add(1337);
    numbers.add(9000);

    System.out.println(binarySearch(numbers, 42));
  }

  // A binary search method that works for any type that can be compared to
  // other values of that type.
  public static <T extends Comparable<T>> int binarySearch(List<T> c, T x) {
    int h = -1;
    int t = c.size();
    while (h + 1 < t) {
      int e = (h + t) / 2;
      if (c.get(e).compareTo(x) <= 0) {
        h = e;
      } else {
        t = e;
      }
    }
    return h;
  }
}
