import java.util.LinkedList;
import java.util.List;

/* Here is a simple class hierarchy. */
class Food { /* ... */ }

class Fruit extends Food {
	public void seeds() { /* ... */ }
}

class Apple extends Fruit {
	public void core() { /* ... */ }
}

class GrannySmith extends Apple { /* ... */ }

public class H_BoundedWildcards {
	public static void main(String[] args) {
		List<Apple> as= new LinkedList<>();
		List<GrannySmith> gs= new LinkedList<>();
		/* Imagine adding a few apples here. */

		// The version without bounded wildcards is illegal to call on the
		// GrannySmith list, but it is OK for the Apple list.
		coreAll1(as);
		// coreAll1(gs); // error

		// The bounded wildcard version works for the GrannySmith list too:
		coreAll2(as);
		coreAll2(gs);
	}

	// A more restrictive version without bounded wildcards.
	public static void coreAll1(List<Apple> apples) {
		for (Apple apple : apples) {
			apple.core();
		}
	}

	// A more flexible version *with* bounded wildcards.
	public static void coreAll2(List<? extends Apple> apples) {
		for (Apple apple : apples) {
			apple.core();
		}
	}

	// The opposite of `extends` is `super`. It's useful for when you
	// want to *modify* a collection. If you just use List<?> here, or even
	// List<? extends Apple>, the `add` call below will be an error.
	public static void addApple(List<? super Fruit> fruit) {
		fruit.add(new Apple());
	}
}
