import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class F_Subtyping {
	public static void main(String[] args) {
		// A LinkedList<T> is compatible with a List<T>.
		// (More precisely,
		// LinkedList<T> is a *subtype* of List<T>.)
		// This works just the same as
		// interface implementation without generics!
		List<Integer> numbers= new LinkedList<>();

		// LinkedList<Integer> numbers= new List<Integer>(); // Not allowed.

		// Should this be allowed?
		List<Object> objects= new LinkedList<>();
		// List<Integer> moreNumbers= objects;
		// How about this?
		// List<Object> moreObjects= numbers;

		// Neither of those is allowed! If they were, we could mix up types
		// when using the collection.
		// Integer someNumber = moreNumbers.get(0); // Might not be an Integer.
		// moreObjects.add("generics are useful"); // Puts a string in an int list.

		// =======================================
		String[] as= new String[10];
		Object[] ao= new Object[10];

		ao= as;
		ao[0]= 2110;
		String s= as[0];

		// =====================================

		ArrayList<String> ls= new ArrayList<>();
		ArrayList<Object> lo= new ArrayList<>();

//		lo= ls;               //Suppose this is legal
//		lo.add(2110);         //Type-checks: Integer subtype Object
//		String s = ls.get(0); //Type-checks: ls is a List<String>

	}
}
