public class D_GenericList {
	public static void main(String[] args) {
		MyList<Integer> numbers= new MyLinkedList<>();
		numbers.add(2);
		numbers.add(1);
		numbers.add(1);
		numbers.add(0);
		System.out.println(numbers);

		MyList<String> words= new MyLinkedList<>();
		words.add("I");
		words.add("<3");
		words.add("Java");
		String thirdWord= words.get(2);
		System.out.println(thirdWord);
	}
}

/* Just one implementation of our list class! */

interface MyList<T> {
	void add(T i);

	T get(int index);
}

class MyLinkedList<T> implements MyList<T> {
	private Node head;

	private class Node {
		T value;
		Node next;
	}

	@Override
	public void add(T value) {
		if (head == null) {
			head= new Node();
			head.value= value;
		} else {
			Node node= head;
			while (node.next != null) {
				node= node.next;
			}
			node.next= new Node();
			node.next.value= value;
		}
	}

	@Override
	public T get(int index) {
		int count= index;
		Node node= head;
		while (count > 0) {
			node= node.next;
			count-- ;
		}
		return node.value;
	}

	@Override
	public String toString() {
		String out= "[";
		Node node= head;
		while (node != null) {
			out+= node.value.toString();
			if (node.next != null) {
				out+= ", ";
			}
			node= node.next;
		}
		out+= "]";
		return out;
	}
}
