import java.util.HashSet;
import java.util.Set;

public class C_WithGenerics {
	public static void main(String[] args) {
		Set<Integer> numbers= new HashSet<>();
		numbers.add(2);
		numbers.add(1);
		numbers.add(1);
		numbers.add(0);
		// numbers.add("two"); // This is an error!
		System.out.println(numbers);

		Set<String> words= new HashSet<>();
		words.add("I");
		words.add("<3");
		words.add("Java");
		// words.add(2); // This is an error too!
		System.out.println(words);

		// You also get strict controls when getting values *out* of
		// a collection.
		for (String word : words) {
			System.out.println(word.length());
		}

		// Without this, you'd need:
		for (Object obj : words) {
			String word= (String) obj;  // Trust me, Java: I know this is a String!
			System.out.println(word.length());
		}
	}
}
